/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
 
package domain.helicopter;

/**
 *
 * @author qing da <daq@lamda.nju.edu.cn>
 */
public class Quaternion {

    public double x;
    public double y;
    public double z;
    public double w;

    public Quaternion(Quaternion qToCopy) {
        this.x = qToCopy.x;
        this.y = qToCopy.y;
        this.z = qToCopy.z;
        this.w = qToCopy.w;
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(HeliVector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = 0.0;
    }

    public Quaternion conj() {
        return new Quaternion(-x, -y, -z, w);
    }

    public HeliVector complex_part() {
        return new HeliVector(this.x, this.y, this.z);
    }

    public Quaternion mult(Quaternion rq) {
        return new Quaternion(this.w * rq.x + this.x * rq.w + this.y * rq.z - this.z * rq.y,
                this.w * rq.y - this.x * rq.z + this.y * rq.w + this.z * rq.x,
                this.w * rq.z + this.x * rq.y - this.y * rq.x + this.z * rq.w,
                this.w * rq.w - this.x * rq.x - this.y * rq.y - this.z * rq.z);
    }

    void stringSerialize(StringBuffer b) {
        b.append("x_" + x);
        b.append("y_" + y);
        b.append("z_" + z);
        b.append("w_" + w);
    }
}
