/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
 
package napping.domain.corridorworld;

import java.util.Random;
import napping.core.Action;
import napping.core.State;
import napping.core.Task;

/**
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public class CWTask extends Task {

    public double noise_mean;
    public double noise_sigma;
    private Random random;

    public CWTask(Random rand) {
        this.noise_mean = 0;
        this.noise_sigma = .2;
        this.actionSet = new int[]{-1, 1};
        this.random = rand;
    }

    @Override
    public State transition(State s, Action a, Random outRand) {
        Random thisRand = outRand == null ? random : outRand;
        CWState cs = (CWState) s;
        int move = actionSet[a.index];
        return new CWState(cs.x + move * 0.2 + (noise_mean + thisRand.nextGaussian()) * noise_sigma);
    }

    @Override
    public double immediateReward(State s) {
        if (isComplete(s)) {
            return 0;
        } else {
            return -1;
        }
    }

    @Override
    public double[] getSAFeature(State s, Action a) {
        double[] feature = s.extractFeature();
        double[] saFea = new double[feature.length + 1];
        System.arraycopy(feature, 0, saFea, 0, feature.length);
        saFea[saFea.length - 1] = a.index;
        return saFea;
    }

    @Override
    public boolean isComplete(State s) {
        CWState cs = (CWState) s;
        if (cs.x >= 10 || cs.x <= 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public State getInitialState() {
        return new CWState((random.nextDouble()-0.5) * 2 + 5);
    }
}
