/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
 
package example.helicopter;

import core.state.State;
import core.task.Task;
import domain.helicopter.HelicopterTask;
import core.exp.Experiment;
import java.util.Random;
import core.policy.PolicyBoostContinuous;

/**
 * This file runs PolicyBoost with napping as in the following paper for the HelicopterHover domain
 *
 * Yang Yu and Qing Da. PolicyBoost: Functional policy gradient with ranking-based reward 
 * objective. In: Proceedings of AAAI Workshop on AI and Robotics (AIRob'14), Quebec City,
 * Canada, 2014.
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public class Demo {

    static int maxStep = 8000;
    static boolean isPara = false;

    public static void main(String[] args) throws Exception {
        Random random = new Random();

        Task task = new HelicopterTask(new Random(random.nextInt()));
        State initialState = task.getInitialState();
        // Napping interval 100 iterations
        PolicyBoostContinuous bpca= new PolicyBoostContinuous(new Random(random.nextInt()), 100);
        bpca.setStepsize(1);
        
        Experiment exp = new Experiment();
        exp.conductExperimentTrainContinuousAction(bpca, task, 1000, 100, initialState, maxStep, isPara, new Random(random.nextInt()));
    }
}
