/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
package example.mountaincar2d;

import core.state.State;
import core.task.Task;
import domain.mountaincar2d.MountainCarTask;
import core.exp.Experiment;
import java.util.Random;
import core.policy.PolicyBoostDiscrete;

/**
 * This file runs PolicyBoost with napping as in the following paper for the
 * MountainCar domain
 *
 * Yang Yu and Qing Da. PolicyBoost: Functional policy gradient with
 * ranking-based reward objective. In: Proceedings of AAAI Workshop on AI and
 * Robotics (AIRob'14), Quebec City, Canada, 2014.
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public class Demo {

    static int maxStep = 2000;
    static boolean isPara = false;

    public static void main(String[] args) throws Exception {
        Random random = new Random();

        // select domain: Mountain Car
        Task task = new MountainCarTask(new Random(random.nextInt()));
        State initialState = task.getInitialState();

        // setup policy: discrete actions
        // Napping interval set to Integer.MAX_VALUE to cancel the napping
        PolicyBoostDiscrete pbD = new PolicyBoostDiscrete(new Random(random.nextInt()), Integer.MAX_VALUE);

        Experiment exp = new Experiment();
        exp.conductExperimentTrainDiscreteAction(pbD, task, 100, 50, initialState, maxStep, isPara, 0, new Random(random.nextInt()));
    }
}
