package Exe;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import pacman.controllers.Controller;
import pacman.game.Constants;
import pacman.game.Constants.MOVE;
import pacman.game.Game;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This is the class you need to modify for your entry. In particular, you need to
 * fill in the getAction() method. Any additional classes you write should either
 * be placed in this package or sub-packages (e.g., game.entries.pacman.mypackage).
 */
public class MyPacMan extends Controller<MOVE>
{
	private MOVE myMove=MOVE.NEUTRAL;
        private Classifier m_classifier = null;
        private Instances m_dataheader = null;
        
        public MyPacMan(String modelfile) throws Exception{
            ObjectInputStream reader = new ObjectInputStream(new FileInputStream(modelfile));
            m_classifier = (Classifier)reader.readObject();
            reader.close();
            
            Instances data = new Instances(new BufferedReader(new FileReader(DataCollect.m_dataFilename)));
            data.setClassIndex(data.numAttributes()-1);
            m_dataheader = new Instances(data,0);
        }
	
	public MOVE getMove(Game game, long timeDue) 
	{
            // set class unknown
            double[] vector = game.getFeature(-1);
                
            vector[vector.length-1] = Double.NaN;
            Instance instance = new Instance(1, vector);
            instance.setDataset(m_dataheader);
                
            try{
                int prediction = (int)m_classifier.classifyInstance(instance);
                myMove = MOVE.values()[prediction];
            }catch(Exception exc){
                exc.printStackTrace();
            }
            return myMove;
	}
}