/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.core.xml.KOML;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstancesResultListener;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.SplitEvaluator;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ExtensionFileFilter;
import weka.gui.experiment.AlgorithmListPanel;
import weka.gui.experiment.DatasetListPanel;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.Messages;
import weka.gui.experiment.SetupModePanel;

public class SimpleSetupPanel
extends JPanel {
    private static final long serialVersionUID = 5257424515609176509L;
    protected Experiment m_Exp;
    protected SetupModePanel m_modePanel = null;
    protected String m_destinationDatabaseURL;
    protected String m_destinationFilename = "";
    protected int m_numFolds = 10;
    protected double m_trainPercent = 66.0;
    protected int m_numRepetitions = 10;
    protected boolean m_userHasBeenAskedAboutConversion;
    protected ExtensionFileFilter m_csvFileFilter;
    protected ExtensionFileFilter m_arffFileFilter;
    protected JButton m_OpenBut;
    protected JButton m_SaveBut;
    protected JButton m_NewBut;
    protected FileFilter m_ExpFilter;
    protected FileFilter m_KOMLFilter;
    protected FileFilter m_XMLFilter;
    protected JFileChooser m_FileChooser;
    protected JFileChooser m_DestFileChooser;
    protected JComboBox m_ResultsDestinationCBox;
    protected JLabel m_ResultsDestinationPathLabel;
    protected JTextField m_ResultsDestinationPathTField;
    protected JButton m_BrowseDestinationButton;
    protected JComboBox m_ExperimentTypeCBox;
    protected JLabel m_ExperimentParameterLabel;
    protected JTextField m_ExperimentParameterTField;
    protected JRadioButton m_ExpClassificationRBut;
    protected JRadioButton m_ExpRegressionRBut;
    protected JTextField m_NumberOfRepetitionsTField;
    protected JRadioButton m_OrderDatasetsFirstRBut;
    protected JRadioButton m_OrderAlgorithmsFirstRBut;
    protected static String DEST_DATABASE_TEXT;
    protected static String DEST_ARFF_TEXT;
    protected static String DEST_CSV_TEXT;
    protected static String TYPE_CROSSVALIDATION_TEXT;
    protected static String TYPE_RANDOMSPLIT_TEXT;
    protected static String TYPE_FIXEDSPLIT_TEXT;
    protected DatasetListPanel m_DatasetListPanel;
    protected AlgorithmListPanel m_AlgorithmListPanel;
    protected JButton m_NotesButton;
    protected JFrame m_NotesFrame;
    protected JTextArea m_NotesText;
    protected PropertyChangeSupport m_Support;

    public SimpleSetupPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public SimpleSetupPanel() {
        Messages.getInstance();
        this.m_csvFileFilter = new ExtensionFileFilter(".csv", Messages.getString("SimpleSetupPanel_CsvFileFilter_Text"));
        Messages.getInstance();
        this.m_arffFileFilter = new ExtensionFileFilter(".arff", Messages.getString("SimpleSetupPanel_ArffFileFilter_Text"));
        Messages.getInstance();
        this.m_OpenBut = new JButton(Messages.getString("SimpleSetupPanel_OpenBut_JButton_Text"));
        Messages.getInstance();
        this.m_SaveBut = new JButton(Messages.getString("SimpleSetupPanel_SaveBut_JButton_Text"));
        Messages.getInstance();
        this.m_NewBut = new JButton(Messages.getString("SimpleSetupPanel_NewBut_JButton_Text"));
        StringBuilder stringBuilder = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("SimpleSetupPanel_ExpFilter_ExtensionFileFilter_Text_First")).append(Experiment.FILE_EXTENSION);
        Messages.getInstance();
        this.m_ExpFilter = new ExtensionFileFilter(Experiment.FILE_EXTENSION, stringBuilder2.append(Messages.getString("SimpleSetupPanel_ExpFilter_ExtensionFileFilter_Text_Second")).toString());
        StringBuilder stringBuilder3 = new StringBuilder();
        Messages.getInstance();
        StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("SimpleSetupPanel_KOMLFilter_ExtensionFileFilter_Text_First")).append(".koml");
        Messages.getInstance();
        this.m_KOMLFilter = new ExtensionFileFilter(".koml", stringBuilder4.append(Messages.getString("SimpleSetupPanel_KOMLFilter_ExtensionFileFilter_Text_Second")).toString());
        Messages.getInstance();
        this.m_XMLFilter = new ExtensionFileFilter(".xml", Messages.getString("SimpleSetupPanel_XMLFilter_ExtensionFileFilter_Text"));
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_DestFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_ResultsDestinationCBox = new JComboBox();
        Messages.getInstance();
        this.m_ResultsDestinationPathLabel = new JLabel(Messages.getString("SimpleSetupPanel_ResultsDestinationPathLabel_JLabel_Text"));
        this.m_ResultsDestinationPathTField = new JTextField();
        Messages.getInstance();
        this.m_BrowseDestinationButton = new JButton(Messages.getString("SimpleSetupPanel_BrowseDestinationButton_JButton_Text"));
        this.m_ExperimentTypeCBox = new JComboBox();
        Messages.getInstance();
        this.m_ExperimentParameterLabel = new JLabel(Messages.getString("SimpleSetupPanel_ExperimentParameterLabel_JLabel_Text"));
        this.m_ExperimentParameterTField = new JTextField();
        Messages.getInstance();
        this.m_ExpClassificationRBut = new JRadioButton(Messages.getString("SimpleSetupPanel_ExpClassificationRBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_ExpRegressionRBut = new JRadioButton(Messages.getString("SimpleSetupPanel_ExpRegressionRBut_JRadioButton_Text"));
        this.m_NumberOfRepetitionsTField = new JTextField();
        Messages.getInstance();
        this.m_OrderDatasetsFirstRBut = new JRadioButton(Messages.getString("SimpleSetupPanel_OrderDatasetsFirstRBut_JRadioButton_Text"));
        Messages.getInstance();
        this.m_OrderAlgorithmsFirstRBut = new JRadioButton(Messages.getString("SimpleSetupPanel_OrderAlgorithmsFirstRBut_JRadioButton_Text"));
        this.m_DatasetListPanel = new DatasetListPanel();
        this.m_AlgorithmListPanel = new AlgorithmListPanel();
        Messages.getInstance();
        this.m_NotesButton = new JButton(Messages.getString("SimpleSetupPanel_NotesButton_JButton_Text"));
        Messages.getInstance();
        this.m_NotesFrame = new JFrame(Messages.getString("SimpleSetupPanel_NotesFrame_JFrame_Text"));
        this.m_NotesText = new JTextArea(null, 10, 0);
        this.m_Support = new PropertyChangeSupport(this);
        this.m_ResultsDestinationCBox.setEnabled(false);
        this.m_ResultsDestinationPathLabel.setEnabled(false);
        this.m_ResultsDestinationPathTField.setEnabled(false);
        this.m_BrowseDestinationButton.setEnabled(false);
        this.m_ExperimentTypeCBox.setEnabled(false);
        this.m_ExperimentParameterLabel.setEnabled(false);
        this.m_ExperimentParameterTField.setEnabled(false);
        this.m_ExpClassificationRBut.setEnabled(false);
        this.m_ExpRegressionRBut.setEnabled(false);
        this.m_NumberOfRepetitionsTField.setEnabled(false);
        this.m_OrderDatasetsFirstRBut.setEnabled(false);
        this.m_OrderAlgorithmsFirstRBut.setEnabled(false);
        try {
            this.m_destinationDatabaseURL = new DatabaseResultListener().getDatabaseURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_NewBut.setMnemonic('N');
        this.m_NewBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Experiment newExp = new Experiment();
                CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
                cvrp.setNumFolds(10);
                cvrp.setSplitEvaluator(new ClassifierSplitEvaluator());
                newExp.setResultProducer(cvrp);
                newExp.setPropertyArray(new Classifier[0]);
                newExp.setUsePropertyIterator(true);
                SimpleSetupPanel.this.setExperiment(newExp);
                if (ExperimenterDefaults.getUseClassification()) {
                    SimpleSetupPanel.this.m_ExpClassificationRBut.setSelected(true);
                } else {
                    SimpleSetupPanel.this.m_ExpRegressionRBut.setSelected(true);
                }
                SimpleSetupPanel.this.setSelectedItem(SimpleSetupPanel.this.m_ResultsDestinationCBox, ExperimenterDefaults.getDestination());
                SimpleSetupPanel.this.destinationTypeChanged();
                SimpleSetupPanel.this.setSelectedItem(SimpleSetupPanel.this.m_ExperimentTypeCBox, ExperimenterDefaults.getExperimentType());
                SimpleSetupPanel.this.m_numRepetitions = ExperimenterDefaults.getRepetitions();
                SimpleSetupPanel.this.m_NumberOfRepetitionsTField.setText("" + SimpleSetupPanel.this.m_numRepetitions);
                if (ExperimenterDefaults.getExperimentType().equals(TYPE_CROSSVALIDATION_TEXT)) {
                    SimpleSetupPanel.this.m_numFolds = ExperimenterDefaults.getFolds();
                    SimpleSetupPanel.this.m_ExperimentParameterTField.setText("" + SimpleSetupPanel.this.m_numFolds);
                } else {
                    SimpleSetupPanel.this.m_trainPercent = ExperimenterDefaults.getTrainPercentage();
                    SimpleSetupPanel.this.m_ExperimentParameterTField.setText("" + SimpleSetupPanel.this.m_trainPercent);
                }
                if (ExperimenterDefaults.getDatasetsFirst()) {
                    SimpleSetupPanel.this.m_OrderDatasetsFirstRBut.setSelected(true);
                } else {
                    SimpleSetupPanel.this.m_OrderAlgorithmsFirstRBut.setSelected(true);
                }
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        this.m_SaveBut.setEnabled(false);
        this.m_SaveBut.setMnemonic('S');
        this.m_SaveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.saveExperiment();
            }
        });
        this.m_OpenBut.setMnemonic('O');
        this.m_OpenBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.openExperiment();
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_ExpFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        if (ExperimenterDefaults.getExtension().equals(".xml")) {
            this.m_FileChooser.setFileFilter(this.m_XMLFilter);
        } else if (KOML.isPresent() && ExperimenterDefaults.getExtension().equals(".koml")) {
            this.m_FileChooser.setFileFilter(this.m_KOMLFilter);
        } else {
            this.m_FileChooser.setFileFilter(this.m_ExpFilter);
        }
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_DestFileChooser.setFileSelectionMode(0);
        this.m_BrowseDestinationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SimpleSetupPanel.this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
                    SimpleSetupPanel.this.chooseURLUsername();
                } else {
                    SimpleSetupPanel.this.chooseDestinationFile();
                }
            }
        });
        this.m_ExpClassificationRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        this.m_ExpRegressionRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        this.m_OrderDatasetsFirstRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SimpleSetupPanel.this.m_Exp != null) {
                    SimpleSetupPanel.this.m_Exp.setAdvanceDataSetFirst(true);
                    SimpleSetupPanel.this.m_Support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_OrderAlgorithmsFirstRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SimpleSetupPanel.this.m_Exp != null) {
                    SimpleSetupPanel.this.m_Exp.setAdvanceDataSetFirst(false);
                    SimpleSetupPanel.this.m_Support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_ResultsDestinationPathTField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.destinationAddressChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.destinationAddressChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.destinationAddressChanged();
            }
        });
        this.m_ExperimentParameterTField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.expParamChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.expParamChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.expParamChanged();
            }
        });
        this.m_NumberOfRepetitionsTField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.numRepetitionsChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.numRepetitionsChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                SimpleSetupPanel.this.numRepetitionsChanged();
            }
        });
        this.m_NotesFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SimpleSetupPanel.this.m_NotesButton.setEnabled(true);
            }
        });
        this.m_NotesFrame.getContentPane().add(new JScrollPane(this.m_NotesText));
        this.m_NotesFrame.setSize(600, 400);
        this.m_NotesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.m_NotesButton.setEnabled(false);
                SimpleSetupPanel.this.m_NotesFrame.setVisible(true);
            }
        });
        this.m_NotesButton.setEnabled(false);
        this.m_NotesText.setEditable(true);
        this.m_NotesText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SimpleSetupPanel.this.m_Exp.setNotes(SimpleSetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_NotesText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SimpleSetupPanel.this.m_Exp.setNotes(SimpleSetupPanel.this.m_NotesText.getText());
            }
        });
        JPanel buttons = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        buttons.add((Component)this.m_OpenBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_SaveBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_NewBut, constraints);
        JPanel destName = new JPanel();
        destName.setLayout(new BorderLayout(5, 5));
        destName.add((Component)this.m_ResultsDestinationPathLabel, "West");
        destName.add((Component)this.m_ResultsDestinationPathTField, "Center");
        this.m_ResultsDestinationCBox.addItem(DEST_ARFF_TEXT);
        this.m_ResultsDestinationCBox.addItem(DEST_CSV_TEXT);
        this.m_ResultsDestinationCBox.addItem(DEST_DATABASE_TEXT);
        this.m_ResultsDestinationCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.destinationTypeChanged();
            }
        });
        JPanel destInner = new JPanel();
        destInner.setLayout(new BorderLayout(5, 5));
        destInner.add((Component)this.m_ResultsDestinationCBox, "West");
        destInner.add((Component)destName, "Center");
        destInner.add((Component)this.m_BrowseDestinationButton, "East");
        JPanel dest = new JPanel();
        dest.setLayout(new BorderLayout());
        Messages.getInstance();
        dest.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SimpleSetupPanel_Dest_JPanel_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        dest.add((Component)destInner, "North");
        JPanel expParam = new JPanel();
        expParam.setLayout(new BorderLayout(5, 5));
        expParam.add((Component)this.m_ExperimentParameterLabel, "West");
        expParam.add((Component)this.m_ExperimentParameterTField, "Center");
        ButtonGroup typeBG = new ButtonGroup();
        typeBG.add(this.m_ExpClassificationRBut);
        typeBG.add(this.m_ExpRegressionRBut);
        this.m_ExpClassificationRBut.setSelected(true);
        JPanel typeRButtons = new JPanel();
        typeRButtons.setLayout(new GridLayout(1, 0));
        typeRButtons.add(this.m_ExpClassificationRBut);
        typeRButtons.add(this.m_ExpRegressionRBut);
        this.m_ExperimentTypeCBox.addItem(TYPE_CROSSVALIDATION_TEXT);
        this.m_ExperimentTypeCBox.addItem(TYPE_RANDOMSPLIT_TEXT);
        this.m_ExperimentTypeCBox.addItem(TYPE_FIXEDSPLIT_TEXT);
        this.m_ExperimentTypeCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        JPanel typeInner = new JPanel();
        typeInner.setLayout(new GridLayout(0, 1));
        typeInner.add(this.m_ExperimentTypeCBox);
        typeInner.add(expParam);
        typeInner.add(typeRButtons);
        JPanel type = new JPanel();
        type.setLayout(new BorderLayout());
        Messages.getInstance();
        type.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SimpleSetupPanel_Type_JPanel_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        type.add((Component)typeInner, "North");
        ButtonGroup iterBG = new ButtonGroup();
        iterBG.add(this.m_OrderDatasetsFirstRBut);
        iterBG.add(this.m_OrderAlgorithmsFirstRBut);
        this.m_OrderDatasetsFirstRBut.setSelected(true);
        JPanel numIter = new JPanel();
        numIter.setLayout(new BorderLayout(5, 5));
        Messages.getInstance();
        numIter.add((Component)new JLabel(Messages.getString("SimpleSetupPanel_NumIter_JPanel_Add_JLabel_Text")), "West");
        numIter.add((Component)this.m_NumberOfRepetitionsTField, "Center");
        JPanel controlInner = new JPanel();
        controlInner.setLayout(new GridLayout(0, 1));
        controlInner.add(numIter);
        controlInner.add(this.m_OrderDatasetsFirstRBut);
        controlInner.add(this.m_OrderAlgorithmsFirstRBut);
        JPanel control = new JPanel();
        control.setLayout(new BorderLayout());
        Messages.getInstance();
        control.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SimpleSetupPanel_Control_JPanel_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        control.add((Component)controlInner, "North");
        JPanel type_control = new JPanel();
        type_control.setLayout(new GridLayout(1, 0));
        type_control.add(type);
        type_control.add(control);
        JPanel notes = new JPanel();
        notes.setLayout(new BorderLayout());
        notes.add((Component)this.m_NotesButton, "Center");
        JPanel top1 = new JPanel();
        top1.setLayout(new BorderLayout());
        top1.add((Component)dest, "North");
        top1.add((Component)type_control, "Center");
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add((Component)buttons, "North");
        top.add((Component)top1, "Center");
        JPanel datasets = new JPanel();
        datasets.setLayout(new BorderLayout());
        datasets.add((Component)this.m_DatasetListPanel, "Center");
        JPanel algorithms = new JPanel();
        algorithms.setLayout(new BorderLayout());
        algorithms.add((Component)this.m_AlgorithmListPanel, "Center");
        JPanel schemes = new JPanel();
        schemes.setLayout(new GridLayout(1, 0));
        schemes.add(datasets);
        schemes.add(algorithms);
        this.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        this.add((Component)schemes, "Center");
        this.add((Component)notes, "South");
    }

    protected void setSelectedItem(JComboBox cb, String item) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!cb.getItemAt(i).toString().equals(item)) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    protected void removeNotesFrame() {
        this.m_NotesFrame.setVisible(false);
    }

    private boolean userWantsToConvert() {
        if (this.m_userHasBeenAskedAboutConversion) {
            return true;
        }
        this.m_userHasBeenAskedAboutConversion = true;
        Messages.getInstance();
        String string = Messages.getString("SimpleSetupPanel_UserWantsToConvert_JOptionPaneShowConfirmDialog_Text_First");
        Messages.getInstance();
        return JOptionPane.showConfirmDialog(this, string, Messages.getString("SimpleSetupPanel_UserWantsToConvert_JOptionPaneShowConfirmDialog_Text_Second"), 0, 2) == 0;
    }

    public void setModePanel(SetupModePanel modePanel) {
        this.m_modePanel = modePanel;
    }

    public boolean setExperiment(Experiment exp) {
        this.m_userHasBeenAskedAboutConversion = false;
        this.m_Exp = null;
        this.m_SaveBut.setEnabled(true);
        if (exp.getResultListener() instanceof DatabaseResultListener) {
            this.m_ResultsDestinationCBox.setSelectedItem(DEST_DATABASE_TEXT);
            Messages.getInstance();
            this.m_ResultsDestinationPathLabel.setText(Messages.getString("SimpleSetupPanel_SetExperiment_DatabaseResultListener_ResultsDestinationPathLabel_Text"));
            this.m_destinationDatabaseURL = ((DatabaseResultListener)exp.getResultListener()).getDatabaseURL();
            this.m_ResultsDestinationPathTField.setText(this.m_destinationDatabaseURL);
            this.m_BrowseDestinationButton.setEnabled(true);
        } else if (exp.getResultListener() instanceof InstancesResultListener) {
            this.m_ResultsDestinationCBox.setSelectedItem(DEST_ARFF_TEXT);
            Messages.getInstance();
            this.m_ResultsDestinationPathLabel.setText(Messages.getString("SimpleSetupPanel_SetExperiment_InstancesResultListener_Text"));
            this.m_destinationFilename = ((InstancesResultListener)exp.getResultListener()).outputFileName();
            this.m_ResultsDestinationPathTField.setText(this.m_destinationFilename);
            this.m_BrowseDestinationButton.setEnabled(true);
        } else if (exp.getResultListener() instanceof CSVResultListener) {
            this.m_ResultsDestinationCBox.setSelectedItem(DEST_CSV_TEXT);
            Messages.getInstance();
            this.m_ResultsDestinationPathLabel.setText(Messages.getString("SimpleSetupPanel_SetExperiment_CSVResultListener_Text"));
            this.m_destinationFilename = ((CSVResultListener)exp.getResultListener()).outputFileName();
            this.m_ResultsDestinationPathTField.setText(this.m_destinationFilename);
            this.m_BrowseDestinationButton.setEnabled(true);
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("SimpleSetupPanel_SetExperiment_UnrecognisedResultListener_Text"));
            if (this.userWantsToConvert()) {
                this.m_ResultsDestinationCBox.setSelectedItem(DEST_ARFF_TEXT);
                Messages.getInstance();
                this.m_ResultsDestinationPathLabel.setText(Messages.getString("SimpleSetupPanel_SetExperiment_UnrecognisedResultListener_UserWantsToConvert_Text"));
                this.m_destinationFilename = "";
                this.m_ResultsDestinationPathTField.setText(this.m_destinationFilename);
                this.m_BrowseDestinationButton.setEnabled(true);
            } else {
                return false;
            }
        }
        this.m_ResultsDestinationCBox.setEnabled(true);
        this.m_ResultsDestinationPathLabel.setEnabled(true);
        this.m_ResultsDestinationPathTField.setEnabled(true);
        if (exp.getResultProducer() instanceof CrossValidationResultProducer) {
            CrossValidationResultProducer cvrp = (CrossValidationResultProducer)exp.getResultProducer();
            this.m_numFolds = cvrp.getNumFolds();
            this.m_ExperimentParameterTField.setText("" + this.m_numFolds);
            if (cvrp.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else if (cvrp.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(false);
                this.m_ExpRegressionRBut.setSelected(true);
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("SimpleSetupPanel_SetExperiment_UnknownSplitEvaluator_Text"));
                if (this.userWantsToConvert()) {
                    this.m_ExpClassificationRBut.setSelected(true);
                    this.m_ExpRegressionRBut.setSelected(false);
                } else {
                    return false;
                }
            }
            this.m_ExperimentTypeCBox.setSelectedItem(TYPE_CROSSVALIDATION_TEXT);
        } else if (exp.getResultProducer() instanceof RandomSplitResultProducer) {
            RandomSplitResultProducer rsrp = (RandomSplitResultProducer)exp.getResultProducer();
            if (rsrp.getRandomizeData()) {
                this.m_ExperimentTypeCBox.setSelectedItem(TYPE_RANDOMSPLIT_TEXT);
            } else {
                this.m_ExperimentTypeCBox.setSelectedItem(TYPE_FIXEDSPLIT_TEXT);
            }
            if (rsrp.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else if (rsrp.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(false);
                this.m_ExpRegressionRBut.setSelected(true);
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("SimpleSetupPanel_SetExperiment_UnknownSplitEvaluator_Text_First"));
                if (this.userWantsToConvert()) {
                    this.m_ExpClassificationRBut.setSelected(true);
                    this.m_ExpRegressionRBut.setSelected(false);
                } else {
                    return false;
                }
            }
            this.m_trainPercent = rsrp.getTrainPercent();
            this.m_ExperimentParameterTField.setText("" + this.m_trainPercent);
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("SimpleSetupPanel_SetExperiment_UnknownPropertyIteration_Text"));
            if (this.userWantsToConvert()) {
                this.m_ExperimentTypeCBox.setSelectedItem(TYPE_CROSSVALIDATION_TEXT);
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else {
                return false;
            }
        }
        this.m_ExperimentTypeCBox.setEnabled(true);
        this.m_ExperimentParameterLabel.setEnabled(true);
        this.m_ExperimentParameterTField.setEnabled(true);
        this.m_ExpClassificationRBut.setEnabled(true);
        this.m_ExpRegressionRBut.setEnabled(true);
        if (exp.getRunLower() == 1) {
            this.m_numRepetitions = exp.getRunUpper();
            this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
        } else {
            Messages.getInstance();
            System.out.println(Messages.getString("SimpleSetupPanel_SetExperiment_UnknownPropertyIteration_Text_Alpha"));
            if (this.userWantsToConvert()) {
                exp.setRunLower(1);
                if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_FIXEDSPLIT_TEXT) {
                    exp.setRunUpper(1);
                    this.m_NumberOfRepetitionsTField.setEnabled(false);
                    this.m_NumberOfRepetitionsTField.setText("1");
                } else {
                    exp.setRunUpper(10);
                    this.m_numRepetitions = 10;
                    this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
                }
            } else {
                return false;
            }
        }
        this.m_NumberOfRepetitionsTField.setEnabled(true);
        this.m_OrderDatasetsFirstRBut.setSelected(exp.getAdvanceDataSetFirst());
        this.m_OrderAlgorithmsFirstRBut.setSelected(!exp.getAdvanceDataSetFirst());
        this.m_OrderDatasetsFirstRBut.setEnabled(true);
        this.m_OrderAlgorithmsFirstRBut.setEnabled(true);
        this.m_NotesText.setText(exp.getNotes());
        this.m_NotesButton.setEnabled(true);
        if (!exp.getUsePropertyIterator() || !(exp.getPropertyArray() instanceof Classifier[])) {
            Messages.getInstance();
            System.out.println(Messages.getString("SimpleSetupPanel_SetExperiment_UnknownPropertyIteration_Text_First"));
            if (this.userWantsToConvert()) {
                exp.setPropertyArray(new Classifier[0]);
                exp.setUsePropertyIterator(true);
            } else {
                return false;
            }
        }
        this.m_DatasetListPanel.setExperiment(exp);
        this.m_AlgorithmListPanel.setExperiment(exp);
        this.m_Exp = exp;
        this.expTypeChanged();
        this.m_Support.firePropertyChange("", null, null);
        return true;
    }

    public Experiment getExperiment() {
        return this.m_Exp;
    }

    private void openExperiment() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File expFile = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!expFile.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                expFile = new File(expFile.getParent(), expFile.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!expFile.getName().toLowerCase().endsWith(".koml")) {
                expFile = new File(expFile.getParent(), expFile.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !expFile.getName().toLowerCase().endsWith(".xml")) {
            expFile = new File(expFile.getParent(), expFile.getName() + ".xml");
        }
        try {
            Experiment exp = Experiment.read(expFile.getAbsolutePath());
            if (!this.setExperiment(exp) && this.m_modePanel != null) {
                this.m_modePanel.switchToAdvanced(exp);
            }
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("SimpleSetupPanel_OpenExperiment_Exception_JOptionPaneShowMessageDialog_Text")).append(exp).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("SimpleSetupPanel_OpenExperiment_Exception_JOptionPaneShowMessageDialog_Text_First")).append(expFile);
            Messages.getInstance();
            String string = stringBuilder2.append(Messages.getString("SimpleSetupPanel_OpenExperiment_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(ex.getMessage()).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("SimpleSetupPanel_OpenExperiment_Exception_JOptionPaneShowMessageDialog_Text_Third"), 0);
        }
    }

    private void saveExperiment() {
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        File expFile = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!expFile.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                expFile = new File(expFile.getParent(), expFile.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!expFile.getName().toLowerCase().endsWith(".koml")) {
                expFile = new File(expFile.getParent(), expFile.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !expFile.getName().toLowerCase().endsWith(".xml")) {
            expFile = new File(expFile.getParent(), expFile.getName() + ".xml");
        }
        try {
            Experiment.write(expFile.getAbsolutePath(), this.m_Exp);
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.err.println(stringBuilder.append(Messages.getString("SimpleSetupPanel_SaveExperiment_Error_Text")).append(this.m_Exp).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("SimpleSetupPanel_SaveExperiment_Exception_JOptionPaneShowMessageDialog_Text_First")).append(expFile);
            Messages.getInstance();
            String string = stringBuilder2.append(Messages.getString("SimpleSetupPanel_SaveExperiment_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(ex.getMessage()).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("SimpleSetupPanel_SaveExperiment_Exception_JOptionPaneShowMessageDialog_Text_Third"), 0);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    private void destinationTypeChanged() {
        if (this.m_Exp == null) {
            return;
        }
        String str = "";
        if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
            Messages.getInstance();
            this.m_ResultsDestinationPathLabel.setText(Messages.getString("SimpleSetupPanel_DestinationTypeChanged_DEST_DATABASE_TEXT_ResultsDestinationPathLabel_Text_First"));
            str = this.m_destinationDatabaseURL;
            this.m_BrowseDestinationButton.setEnabled(true);
            Messages.getInstance();
            this.m_BrowseDestinationButton.setText(Messages.getString("SimpleSetupPanel_DestinationTypeChanged_DEST_DATABASE_TEXT_BrowseDestinationButton_Text"));
        } else {
            int ind;
            Messages.getInstance();
            this.m_ResultsDestinationPathLabel.setText(Messages.getString("SimpleSetupPanel_DestinationTypeChanged_DEST_DATABASE_TEXT_ResultsDestinationPathLabel_Text_Second"));
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT && (ind = this.m_destinationFilename.lastIndexOf(".csv")) > -1) {
                this.m_destinationFilename = this.m_destinationFilename.substring(0, ind) + ".arff";
            }
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT && (ind = this.m_destinationFilename.lastIndexOf(".arff")) > -1) {
                this.m_destinationFilename = this.m_destinationFilename.substring(0, ind) + ".csv";
            }
            str = this.m_destinationFilename;
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT && (ind = str.lastIndexOf(".csv")) > -1) {
                str = str.substring(0, ind) + ".arff";
            }
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT && (ind = str.lastIndexOf(".arff")) > -1) {
                str = str.substring(0, ind) + ".csv";
            }
            this.m_BrowseDestinationButton.setEnabled(true);
            Messages.getInstance();
            this.m_BrowseDestinationButton.setText(Messages.getString("SimpleSetupPanel_DestinationTypeChanged_BrowseDestinationButton_Text"));
        }
        if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
            DatabaseResultListener drl = null;
            try {
                drl = new DatabaseResultListener();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            drl.setDatabaseURL(this.m_destinationDatabaseURL);
            this.m_Exp.setResultListener(drl);
        } else if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT) {
            InstancesResultListener irl = new InstancesResultListener();
            if (!this.m_destinationFilename.equals("")) {
                irl.setOutputFile(new File(this.m_destinationFilename));
            }
            this.m_Exp.setResultListener(irl);
        } else if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT) {
            CSVResultListener crl = new CSVResultListener();
            if (!this.m_destinationFilename.equals("")) {
                crl.setOutputFile(new File(this.m_destinationFilename));
            }
            this.m_Exp.setResultListener(crl);
        }
        this.m_ResultsDestinationPathTField.setText(str);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void destinationAddressChanged() {
        if (this.m_Exp == null) {
            return;
        }
        if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
            this.m_destinationDatabaseURL = this.m_ResultsDestinationPathTField.getText();
            if (this.m_Exp.getResultListener() instanceof DatabaseResultListener) {
                ((DatabaseResultListener)this.m_Exp.getResultListener()).setDatabaseURL(this.m_destinationDatabaseURL);
            }
        } else {
            File resultsFile = null;
            this.m_destinationFilename = this.m_ResultsDestinationPathTField.getText();
            if (this.m_destinationFilename.equals("")) {
                try {
                    if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT) {
                        resultsFile = File.createTempFile("weka_experiment", ".arff");
                    }
                    if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT) {
                        resultsFile = File.createTempFile("weka_experiment", ".csv");
                    }
                    resultsFile.deleteOnExit();
                }
                catch (Exception e) {
                    Messages.getInstance();
                    System.err.println(Messages.getString("SimpleSetupPanel_DestinationAddressChanged_Exception_Text"));
                    resultsFile = new File("-");
                }
            } else {
                if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT && !this.m_destinationFilename.endsWith(".arff")) {
                    this.m_destinationFilename = this.m_destinationFilename + ".arff";
                }
                if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT && !this.m_destinationFilename.endsWith(".csv")) {
                    this.m_destinationFilename = this.m_destinationFilename + ".csv";
                }
                resultsFile = new File(this.m_destinationFilename);
            }
            ((CSVResultListener)this.m_Exp.getResultListener()).setOutputFile(resultsFile);
            ((CSVResultListener)this.m_Exp.getResultListener()).setOutputFileName(this.m_destinationFilename);
        }
        this.m_Support.firePropertyChange("", null, null);
    }

    private void expTypeChanged() {
        if (this.m_Exp == null) {
            return;
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            Messages.getInstance();
            this.m_ExperimentParameterLabel.setText(Messages.getString("SimpleSetupPanel_ExpTypeChanged_TYPE_CROSSVALIDATION_TEXT_ExperimentParameterLabel_Text_First"));
            this.m_ExperimentParameterTField.setText("" + this.m_numFolds);
        } else {
            Messages.getInstance();
            this.m_ExperimentParameterLabel.setText(Messages.getString("SimpleSetupPanel_ExpTypeChanged_TYPE_CROSSVALIDATION_TEXT_ExperimentParameterLabel_Text_Second"));
            this.m_ExperimentParameterTField.setText("" + this.m_trainPercent);
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_FIXEDSPLIT_TEXT) {
            this.m_NumberOfRepetitionsTField.setEnabled(false);
            this.m_NumberOfRepetitionsTField.setText("1");
            this.m_Exp.setRunLower(1);
            this.m_Exp.setRunUpper(1);
        } else {
            this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
            this.m_NumberOfRepetitionsTField.setEnabled(true);
            this.m_Exp.setRunLower(1);
            this.m_Exp.setRunUpper(this.m_numRepetitions);
        }
        SplitEvaluator se = null;
        Classifier sec = null;
        if (this.m_ExpClassificationRBut.isSelected()) {
            se = new ClassifierSplitEvaluator();
            sec = ((ClassifierSplitEvaluator)se).getClassifier();
        } else {
            se = new RegressionSplitEvaluator();
            sec = ((RegressionSplitEvaluator)se).getClassifier();
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
            cvrp.setNumFolds(this.m_numFolds);
            cvrp.setSplitEvaluator(se);
            PropertyNode[] propertyPath = new PropertyNode[2];
            try {
                propertyPath[0] = new PropertyNode(se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
                propertyPath[1] = new PropertyNode(sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            this.m_Exp.setResultProducer(cvrp);
            this.m_Exp.setPropertyPath(propertyPath);
        } else {
            RandomSplitResultProducer rsrp = new RandomSplitResultProducer();
            rsrp.setRandomizeData(this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_RANDOMSPLIT_TEXT);
            rsrp.setTrainPercent(this.m_trainPercent);
            rsrp.setSplitEvaluator(se);
            PropertyNode[] propertyPath = new PropertyNode[2];
            try {
                propertyPath[0] = new PropertyNode(se, new PropertyDescriptor("splitEvaluator", RandomSplitResultProducer.class), RandomSplitResultProducer.class);
                propertyPath[1] = new PropertyNode(sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            this.m_Exp.setResultProducer(rsrp);
            this.m_Exp.setPropertyPath(propertyPath);
        }
        this.m_Exp.setUsePropertyIterator(true);
        this.m_Support.firePropertyChange("", null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expParamChanged() {
        if (this.m_Exp == null) {
            return;
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            try {
                this.m_numFolds = Integer.parseInt(this.m_ExperimentParameterTField.getText());
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        try {
            this.m_trainPercent = Double.parseDouble(this.m_ExperimentParameterTField.getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            if (!(this.m_Exp.getResultProducer() instanceof CrossValidationResultProducer)) return;
            CrossValidationResultProducer cvrp = (CrossValidationResultProducer)this.m_Exp.getResultProducer();
            cvrp.setNumFolds(this.m_numFolds);
        } else {
            if (!(this.m_Exp.getResultProducer() instanceof RandomSplitResultProducer)) return;
            RandomSplitResultProducer rsrp = (RandomSplitResultProducer)this.m_Exp.getResultProducer();
            rsrp.setRandomizeData(this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_RANDOMSPLIT_TEXT);
            rsrp.setTrainPercent(this.m_trainPercent);
        }
        this.m_Support.firePropertyChange("", null, null);
    }

    private void numRepetitionsChanged() {
        if (this.m_Exp == null || !this.m_NumberOfRepetitionsTField.isEnabled()) {
            return;
        }
        try {
            this.m_numRepetitions = Integer.parseInt(this.m_NumberOfRepetitionsTField.getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        this.m_Exp.setRunLower(1);
        this.m_Exp.setRunUpper(this.m_numRepetitions);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void chooseURLUsername() {
        String dbaseURL = ((DatabaseResultListener)this.m_Exp.getResultListener()).getDatabaseURL();
        String username = ((DatabaseResultListener)this.m_Exp.getResultListener()).getUsername();
        DatabaseConnectionDialog dbd = new DatabaseConnectionDialog(null, dbaseURL, username);
        dbd.setVisible(true);
        if (dbd.getReturnValue() == -1) {
            return;
        }
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setUsername(dbd.getUsername());
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setPassword(dbd.getPassword());
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setDatabaseURL(dbd.getURL());
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setDebug(dbd.getDebug());
        this.m_ResultsDestinationPathTField.setText(dbd.getURL());
    }

    private void chooseDestinationFile() {
        ExtensionFileFilter fileFilter = null;
        fileFilter = this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT ? this.m_csvFileFilter : this.m_arffFileFilter;
        this.m_DestFileChooser.setFileFilter(fileFilter);
        int returnVal = this.m_DestFileChooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        this.m_ResultsDestinationPathTField.setText(this.m_DestFileChooser.getSelectedFile().toString());
    }

    static {
        Messages.getInstance();
        DEST_DATABASE_TEXT = Messages.getString("SimpleSetupPanel_DEST_DATABASE_TEXT_Text");
        Messages.getInstance();
        DEST_ARFF_TEXT = Messages.getString("SimpleSetupPanel_DEST_ARFF_TEXT_Text");
        Messages.getInstance();
        DEST_CSV_TEXT = Messages.getString("SimpleSetupPanel_DEST_CSV_TEXT_Text");
        Messages.getInstance();
        TYPE_CROSSVALIDATION_TEXT = Messages.getString("SimpleSetupPanel_TYPE_CROSSVALIDATION_TEXT_Text");
        Messages.getInstance();
        TYPE_RANDOMSPLIT_TEXT = Messages.getString("SimpleSetupPanel_TYPE_RANDOMSPLIT_TEXT_Text");
        Messages.getInstance();
        TYPE_FIXEDSPLIT_TEXT = Messages.getString("SimpleSetupPanel_TYPE_FIXEDSPLIT_TEXT_Text");
    }
}

