/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.pmml.DerivedFieldMetaInfo;
import weka.core.pmml.MiningFieldMetaInfo;
import weka.core.pmml.TargetMetaInfo;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiningSchema
implements Serializable {
    private static final long serialVersionUID = 7144380586726330455L;
    protected Instances m_fieldInstancesStructure;
    protected Instances m_miningSchemaInstancesStructure;
    protected ArrayList<MiningFieldMetaInfo> m_miningMeta = new ArrayList();
    protected ArrayList<DerivedFieldMetaInfo> m_derivedMeta = new ArrayList();
    protected TransformationDictionary m_transformationDictionary = null;
    protected TargetMetaInfo m_targetMetaInfo = null;

    private void getLocalTransformations(Element model) throws Exception {
        NodeList temp = model.getElementsByTagName("LocalTransformations");
        if (temp.getLength() > 0) {
            Element localT = (Element)temp.item(0);
            ArrayList<Attribute> fieldDefs = new ArrayList<Attribute>();
            for (int i = 0; i < this.m_miningSchemaInstancesStructure.numAttributes(); ++i) {
                fieldDefs.add(this.m_miningSchemaInstancesStructure.attribute(i));
            }
            NodeList localDerivedL = localT.getElementsByTagName("DerivedField");
            for (int i = 0; i < localDerivedL.getLength(); ++i) {
                Node localDerived = localDerivedL.item(i);
                if (localDerived.getNodeType() != 1) continue;
                DerivedFieldMetaInfo d = new DerivedFieldMetaInfo((Element)localDerived, fieldDefs, this.m_transformationDictionary);
                this.m_derivedMeta.add(d);
            }
        }
    }

    public MiningSchema(Element model, Instances dataDictionary, TransformationDictionary transDict) throws Exception {
        NodeList nodeList;
        FastVector attInfo = new FastVector();
        NodeList fieldList = model.getElementsByTagName("MiningField");
        int classIndex = -1;
        int addedCount = 0;
        for (int i = 0; i < fieldList.getLength(); ++i) {
            Element miningFieldEl;
            MiningFieldMetaInfo mfi;
            Node node = fieldList.item(i);
            if (node.getNodeType() != 1 || (mfi = new MiningFieldMetaInfo(miningFieldEl = (Element)node)).getUsageType() != MiningFieldMetaInfo.Usage.ACTIVE && mfi.getUsageType() != MiningFieldMetaInfo.Usage.PREDICTED) continue;
            Attribute miningAtt = dataDictionary.attribute(mfi.getName());
            if (miningAtt != null) {
                mfi.setIndex(addedCount);
                attInfo.addElement(miningAtt);
                ++addedCount;
                if (mfi.getUsageType() == MiningFieldMetaInfo.Usage.PREDICTED) {
                    classIndex = addedCount - 1;
                }
                this.m_miningMeta.add(mfi);
                continue;
            }
            throw new Exception("Can't find mining field: " + mfi.getName() + " in the data dictionary.");
        }
        this.m_miningSchemaInstancesStructure = new Instances("miningSchema", attInfo, 0);
        for (MiningFieldMetaInfo miningFieldMetaInfo : this.m_miningMeta) {
            miningFieldMetaInfo.setMiningSchemaInstances(this.m_miningSchemaInstancesStructure);
        }
        this.m_transformationDictionary = transDict;
        if (this.m_transformationDictionary != null) {
            this.m_transformationDictionary.setFieldDefsForDerivedFields(this.m_miningSchemaInstancesStructure);
            ArrayList<DerivedFieldMetaInfo> transDerived = transDict.getDerivedFields();
            this.m_derivedMeta.addAll(transDerived);
        }
        this.getLocalTransformations(model);
        FastVector newStructure = new FastVector();
        for (MiningFieldMetaInfo m : this.m_miningMeta) {
            newStructure.addElement(m.getFieldAsAttribute());
        }
        for (DerivedFieldMetaInfo d : this.m_derivedMeta) {
            newStructure.addElement(d.getFieldAsAttribute());
        }
        this.m_fieldInstancesStructure = new Instances("FieldStructure", newStructure, 0);
        if (classIndex != -1) {
            this.m_fieldInstancesStructure.setClassIndex(classIndex);
            this.m_miningSchemaInstancesStructure.setClassIndex(classIndex);
        }
        if ((nodeList = model.getElementsByTagName("Targets")).getLength() > 0) {
            if (nodeList.getLength() > 1) {
                throw new Exception("[MiningSchema] Can only handle a single Target");
            }
            Node te = nodeList.item(0);
            if (te.getNodeType() == 1) {
                ArrayList<String> targetVals;
                this.m_targetMetaInfo = new TargetMetaInfo((Element)te);
                if (this.m_fieldInstancesStructure.classIndex() >= 0 && this.m_fieldInstancesStructure.classAttribute().isString() && (targetVals = this.m_targetMetaInfo.getValues()).size() > 0) {
                    Attribute classAtt = this.m_fieldInstancesStructure.classAttribute();
                    for (int i = 0; i < targetVals.size(); ++i) {
                        classAtt.addStringValue(targetVals.get(i));
                    }
                }
            }
        }
    }

    public void applyMissingValuesTreatment(double[] values) throws Exception {
        for (int i = 0; i < this.m_miningMeta.size(); ++i) {
            MiningFieldMetaInfo mfi = this.m_miningMeta.get(i);
            values[i] = mfi.applyMissingValueTreatment(values[i]);
        }
    }

    public void applyOutlierTreatment(double[] values) throws Exception {
        for (int i = 0; i < this.m_miningMeta.size(); ++i) {
            MiningFieldMetaInfo mfi = this.m_miningMeta.get(i);
            values[i] = mfi.applyOutlierTreatment(values[i]);
        }
    }

    public void applyMissingAndOutlierTreatments(double[] values) throws Exception {
        for (int i = 0; i < this.m_miningMeta.size(); ++i) {
            MiningFieldMetaInfo mfi = this.m_miningMeta.get(i);
            values[i] = mfi.applyMissingValueTreatment(values[i]);
            values[i] = mfi.applyOutlierTreatment(values[i]);
        }
    }

    public Instances getFieldsAsInstances() {
        return this.m_fieldInstancesStructure;
    }

    public Instances getMiningSchemaAsInstances() {
        return this.m_miningSchemaInstancesStructure;
    }

    public TransformationDictionary getTransformationDictionary() {
        return this.m_transformationDictionary;
    }

    public boolean hasTargetMetaData() {
        return this.m_targetMetaInfo != null;
    }

    public TargetMetaInfo getTargetMetaData() {
        return this.m_targetMetaInfo;
    }

    public void convertStringAttsToNominal() {
        Instances miningSchemaI = this.getFieldsAsInstances();
        if (miningSchemaI.checkForStringAttributes()) {
            FastVector attInfo = new FastVector();
            for (int i = 0; i < miningSchemaI.numAttributes(); ++i) {
                Attribute tempA = miningSchemaI.attribute(i);
                if (tempA.isString()) {
                    FastVector valueVector = new FastVector();
                    for (int j = 0; j < tempA.numValues(); ++j) {
                        valueVector.addElement(tempA.value(j));
                    }
                    Attribute newAtt = new Attribute(tempA.name(), valueVector);
                    attInfo.addElement(newAtt);
                    continue;
                }
                attInfo.addElement(tempA);
            }
            Instances newI = new Instances("miningSchema", attInfo, 0);
            if (this.m_fieldInstancesStructure.classIndex() >= 0) {
                newI.setClassIndex(this.m_fieldInstancesStructure.classIndex());
            }
            this.m_fieldInstancesStructure = newI;
        }
    }

    public void convertNumericAttToNominal(int index, ArrayList<String> newVals) {
        Instances miningSchemaI = this.getFieldsAsInstances();
        if (miningSchemaI.attribute(index).isNominal()) {
            throw new IllegalArgumentException("[MiningSchema] convertNumericAttToNominal: attribute is already nominal!");
        }
        FastVector newValues = new FastVector();
        for (int i = 0; i < newVals.size(); ++i) {
            newValues.addElement(newVals.get(i));
        }
        FastVector attInfo = new FastVector();
        for (int i = 0; i < miningSchemaI.numAttributes(); ++i) {
            Attribute tempA = miningSchemaI.attribute(i);
            if (i == index) {
                Attribute newAtt = new Attribute(tempA.name(), newValues);
                attInfo.addElement(newAtt);
                continue;
            }
            attInfo.addElement(tempA);
        }
        Instances newI = new Instances("miningSchema", attInfo, 0);
        if (this.m_fieldInstancesStructure.classIndex() >= 0) {
            newI.setClassIndex(this.m_fieldInstancesStructure.classIndex());
        }
        this.m_fieldInstancesStructure = newI;
    }

    public ArrayList<DerivedFieldMetaInfo> getDerivedFields() {
        return this.m_derivedMeta;
    }

    public ArrayList<MiningFieldMetaInfo> getMiningFields() {
        return this.m_miningMeta;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        if (this.m_transformationDictionary != null) {
            temp.append(this.m_transformationDictionary);
        }
        temp.append("Mining schema:\n\n");
        for (MiningFieldMetaInfo m : this.m_miningMeta) {
            temp.append(m + "\n");
        }
        if (this.m_derivedMeta.size() > 0) {
            temp.append("\nDerived fields:\n\n");
            for (DerivedFieldMetaInfo d : this.m_derivedMeta) {
                temp.append(d + "\n");
            }
        }
        temp.append("\n");
        return temp.toString();
    }
}

