/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import weka.clusterers.EM;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Clusterer
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener {
    private static final long serialVersionUID = 7729795159836843810L;
    protected BeanVisual m_visual = new BeanVisual("Clusterer", "weka/gui/beans/icons/EM.gif", "weka/gui/beans/icons/EM_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private static int CLUSTERING = 2;
    private int m_state = IDLE;
    private Thread m_buildThread = null;
    protected String m_globalInfo;
    private Hashtable m_listenees = new Hashtable();
    private Vector m_batchClustererListeners = new Vector();
    private Vector m_graphListeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Instances m_trainingSet;
    private transient Instances m_testingSet;
    private weka.clusterers.Clusterer m_Clusterer = new EM();
    private transient Logger m_log = null;
    private Double m_dummy = new Double(0.0);
    private transient JFileChooser m_fileChooser = null;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Clusterer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setClusterer(this.m_Clusterer);
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setClusterer(weka.clusterers.Clusterer c) {
        boolean loadImages = true;
        if (c.getClass().getName().compareTo(this.m_Clusterer.getClass().getName()) == 0) {
            loadImages = false;
        } else {
            this.m_trainingSet = null;
        }
        this.m_Clusterer = c;
        String clustererName = c.getClass().toString();
        clustererName = clustererName.substring(clustererName.lastIndexOf(46) + 1, clustererName.length());
        if (loadImages && !this.m_visual.loadIcons("weka/gui/beans/icons/" + clustererName + ".gif", "weka/gui/beans/icons/" + clustererName + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(clustererName);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Clusterer);
    }

    public boolean hasIncomingBatchInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet") || this.m_listenees.containsKey("dataSet");
    }

    public weka.clusterers.Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.clusterers.Clusterer)) {
            StringBuilder stringBuilder = new StringBuilder().append(algorithm.getClass());
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("Clusterer_SetWrappedAlgorithm_IllegalArgumentException_Text")).toString());
        }
        this.setClusterer((weka.clusterers.Clusterer)algorithm);
    }

    public Object getWrappedAlgorithm() {
        return this.getClusterer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTrainingSet(final TrainingSetEvent e) {
        block7: {
            if (e.isStructureOnly()) {
                BatchClustererEvent ce = new BatchClustererEvent(this, this.m_Clusterer, new DataSetEvent(this, e.getTrainingSet()), e.getSetNumber(), e.getMaxSetNumber(), 1);
                this.notifyBatchClustererListeners(ce);
                return;
            }
            if (this.m_buildThread == null) {
                try {
                    if (this.m_state != IDLE) break block7;
                    Clusterer ce = this;
                    synchronized (ce) {
                        this.m_state = BUILDING_MODEL;
                    }
                    this.m_trainingSet = e.getTrainingSet();
                    this.m_buildThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block22: {
                                    try {
                                        String string;
                                        if (Clusterer.this.m_trainingSet == null) break block22;
                                        Clusterer.this.m_visual.setAnimated();
                                        if (Clusterer.this.m_log != null) {
                                            Logger logger = Clusterer.this.m_log;
                                            StringBuilder stringBuilder = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                            Messages.getInstance();
                                            logger.statusMessage(stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text")).toString());
                                        }
                                        Clusterer.this.buildClusterer();
                                        if (Clusterer.this.m_batchClustererListeners.size() > 0) {
                                            BatchClustererEvent ce = new BatchClustererEvent(this, Clusterer.this.m_Clusterer, new DataSetEvent(this, e.getTrainingSet()), e.getSetNumber(), e.getMaxSetNumber(), 1);
                                            Clusterer.this.notifyBatchClustererListeners(ce);
                                        }
                                        if (Clusterer.this.m_Clusterer instanceof Drawable && Clusterer.this.m_graphListeners.size() > 0) {
                                            String grphString = ((Drawable)((Object)Clusterer.this.m_Clusterer)).graph();
                                            int grphType = ((Drawable)((Object)Clusterer.this.m_Clusterer)).graphType();
                                            String grphTitle = Clusterer.this.m_Clusterer.getClass().getName();
                                            grphTitle = grphTitle.substring(grphTitle.lastIndexOf(46) + 1, grphTitle.length());
                                            StringBuilder stringBuilder = new StringBuilder();
                                            Messages.getInstance();
                                            grphTitle = stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_GrphTitle_Text_First")).append(e.getSetNumber()).append(" (").append(e.getTrainingSet().relationName()).append(") ").append(grphTitle).toString();
                                            GraphEvent ge = new GraphEvent(Clusterer.this, grphString, grphTitle, grphType);
                                            Clusterer.this.notifyGraphListeners(ge);
                                        }
                                        if (Clusterer.this.m_textListeners.size() <= 0) break block22;
                                        String modelString = Clusterer.this.m_Clusterer.toString();
                                        String titleString = Clusterer.this.m_Clusterer.getClass().getName();
                                        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                                        StringBuilder stringBuilder = new StringBuilder();
                                        Messages.getInstance();
                                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_ModelString_Text_First")).append(titleString);
                                        Messages.getInstance();
                                        StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Clusterer_AcceptTrainingSet_ModelString_Text_Second")).append(Clusterer.this.m_trainingSet.relationName());
                                        if (e.getMaxSetNumber() > 1) {
                                            StringBuilder stringBuilder4 = new StringBuilder();
                                            Messages.getInstance();
                                            string = stringBuilder4.append(Messages.getString("Clusterer_AcceptTrainingSet_ModelString_Text_Third")).append(e.getSetNumber()).toString();
                                        } else {
                                            string = "";
                                        }
                                        modelString = stringBuilder3.append(string).append("\n\n").append(modelString).toString();
                                        StringBuilder stringBuilder5 = new StringBuilder();
                                        Messages.getInstance();
                                        titleString = stringBuilder5.append(Messages.getString("Clusterer_AcceptTrainingSet_TitleString_Text")).append(titleString).toString();
                                        TextEvent nt = new TextEvent(Clusterer.this, modelString, titleString);
                                        Clusterer.this.notifyTextListeners(nt);
                                    }
                                    catch (Exception ex) {
                                        Clusterer.this.stop();
                                        if (Clusterer.this.m_log != null) {
                                            Logger logger = Clusterer.this.m_log;
                                            StringBuilder stringBuilder = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                            Messages.getInstance();
                                            logger.statusMessage(stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_First")).toString());
                                            Logger logger2 = Clusterer.this.m_log;
                                            StringBuilder stringBuilder6 = new StringBuilder();
                                            Messages.getInstance();
                                            StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_First")).append(Clusterer.this.statusMessagePrefix());
                                            Messages.getInstance();
                                            logger2.logMessage(stringBuilder7.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_First_Alpha")).append(ex.getMessage()).toString());
                                        }
                                        ex.printStackTrace();
                                        Object var6_8 = null;
                                        Clusterer.this.m_visual.setStatic();
                                        Clusterer.this.m_state = IDLE;
                                        if (this.isInterrupted()) {
                                            Clusterer.this.m_trainingSet = null;
                                            if (Clusterer.this.m_log != null) {
                                                Logger logger = Clusterer.this.m_log;
                                                StringBuilder stringBuilder = new StringBuilder();
                                                Messages.getInstance();
                                                StringBuilder stringBuilder8 = stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_First")).append(Clusterer.this.statusMessagePrefix());
                                                Messages.getInstance();
                                                logger.logMessage(stringBuilder8.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_Second")).toString());
                                                Logger logger3 = Clusterer.this.m_log;
                                                StringBuilder stringBuilder9 = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                                Messages.getInstance();
                                                logger3.statusMessage(stringBuilder9.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Second")).toString());
                                            }
                                        } else {
                                            Clusterer.this.m_trainingSet = new Instances(Clusterer.this.m_trainingSet, 0);
                                            if (Clusterer.this.m_log != null) {
                                                Logger logger = Clusterer.this.m_log;
                                                StringBuilder stringBuilder = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                                Messages.getInstance();
                                                logger.statusMessage(stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Third")).toString());
                                            }
                                        }
                                        Clusterer.this.block(false);
                                        return;
                                    }
                                }
                                Object var6_7 = null;
                                Clusterer.this.m_visual.setStatic();
                                Clusterer.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Clusterer.this.m_trainingSet = null;
                                    if (Clusterer.this.m_log != null) {
                                        Logger logger = Clusterer.this.m_log;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        Messages.getInstance();
                                        StringBuilder stringBuilder10 = stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_First")).append(Clusterer.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger.logMessage(stringBuilder10.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_Second")).toString());
                                        Logger logger4 = Clusterer.this.m_log;
                                        StringBuilder stringBuilder11 = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger4.statusMessage(stringBuilder11.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Second")).toString());
                                    }
                                } else {
                                    Clusterer.this.m_trainingSet = new Instances(Clusterer.this.m_trainingSet, 0);
                                    if (Clusterer.this.m_log != null) {
                                        Logger logger = Clusterer.this.m_log;
                                        StringBuilder stringBuilder = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger.statusMessage(stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Third")).toString());
                                    }
                                }
                                Clusterer.this.block(false);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var6_9 = null;
                                Clusterer.this.m_visual.setStatic();
                                Clusterer.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Clusterer.this.m_trainingSet = null;
                                    if (Clusterer.this.m_log != null) {
                                        Logger logger = Clusterer.this.m_log;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        Messages.getInstance();
                                        StringBuilder stringBuilder12 = stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_First")).append(Clusterer.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger.logMessage(stringBuilder12.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_Second")).toString());
                                        Logger logger5 = Clusterer.this.m_log;
                                        StringBuilder stringBuilder13 = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger5.statusMessage(stringBuilder13.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Second")).toString());
                                    }
                                } else {
                                    Clusterer.this.m_trainingSet = new Instances(Clusterer.this.m_trainingSet, 0);
                                    if (Clusterer.this.m_log != null) {
                                        Logger logger = Clusterer.this.m_log;
                                        StringBuilder stringBuilder = new StringBuilder().append(Clusterer.this.statusMessagePrefix());
                                        Messages.getInstance();
                                        logger.statusMessage(stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Third")).toString());
                                    }
                                }
                                Clusterer.this.block(false);
                                throw throwable;
                            }
                        }
                    };
                    this.m_buildThread.setPriority(1);
                    this.m_buildThread.start();
                    this.block(true);
                    this.m_buildThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTestSet(TestSetEvent e) {
        block8: {
            if (this.m_trainingSet != null) {
                try {
                    if (this.m_state != IDLE) break block8;
                    Clusterer clusterer = this;
                    synchronized (clusterer) {
                        this.m_state = CLUSTERING;
                    }
                    this.m_testingSet = e.getTestSet();
                    if (this.m_trainingSet.equalHeaders(this.m_testingSet)) {
                        BatchClustererEvent ce = new BatchClustererEvent(this, this.m_Clusterer, new DataSetEvent(this, e.getTestSet()), e.getSetNumber(), e.getMaxSetNumber(), 0);
                        this.notifyBatchClustererListeners(ce);
                    }
                    this.m_state = IDLE;
                }
                catch (Exception ex) {
                    this.stop();
                    if (this.m_log != null) {
                        StringBuilder stringBuilder = new StringBuilder().append(this.statusMessagePrefix());
                        Messages.getInstance();
                        this.m_log.statusMessage(stringBuilder.append(Messages.getString("Clusterer_AcceptTrainingSet_StatusMessage_Text_Fourth")).toString());
                        StringBuilder stringBuilder2 = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_Third")).append(this.statusMessagePrefix());
                        Messages.getInstance();
                        this.m_log.logMessage(stringBuilder3.append(Messages.getString("Clusterer_AcceptTrainingSet_LogMessage_Text_Fourth")).append(ex.getMessage()).toString());
                    }
                    ex.printStackTrace();
                }
            }
        }
    }

    private void buildClusterer() throws Exception {
        if (this.m_trainingSet.classIndex() < 0) {
            this.m_Clusterer.buildClusterer(this.m_trainingSet);
        } else {
            Remove removeClass = new Remove();
            removeClass.setAttributeIndices("" + (this.m_trainingSet.classIndex() + 1));
            removeClass.setInvertSelection(false);
            removeClass.setInputFormat(this.m_trainingSet);
            Instances clusterTrain = Filter.useFilter(this.m_trainingSet, removeClass);
            this.m_Clusterer.buildClusterer(clusterTrain);
        }
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClusterer.gif", "weka/gui/beans/icons/DefaultClusterer_animated.gif");
    }

    public synchronized void addBatchClustererListener(BatchClustererListener cl) {
        this.m_batchClustererListeners.addElement(cl);
    }

    public synchronized void removeBatchClustererListener(BatchClustererListener cl) {
        this.m_batchClustererListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatchClustererListeners(BatchClustererEvent ce) {
        Vector l;
        Clusterer clusterer = this;
        synchronized (clusterer) {
            l = (Vector)this.m_batchClustererListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((BatchClustererListener)l.elementAt(i)).acceptClusterer(ce);
            }
        }
    }

    public synchronized void addGraphListener(GraphListener cl) {
        this.m_graphListeners.addElement(cl);
    }

    public synchronized void removeGraphListener(GraphListener cl) {
        this.m_graphListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent ge) {
        Vector l;
        Clusterer clusterer = this;
        synchronized (clusterer) {
            l = (Vector)this.m_graphListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((GraphListener)l.elementAt(i)).acceptGraph(ge);
            }
        }
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent ge) {
        Vector l;
        Clusterer clusterer = this;
        synchronized (clusterer) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(ge);
            }
        }
    }

    public boolean connectionAllowed(String eventName) {
        return !this.m_listenees.containsKey(eventName);
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenees.put(eventName, source);
        }
    }

    public synchronized void disconnectionNotification(String eventName, Object source) {
        this.m_listenees.remove(eventName);
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_buildThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public boolean isBusy() {
        return this.m_buildThread != null;
    }

    public void stop() {
        Enumeration en = this.m_listenees.keys();
        while (en.hasMoreElements()) {
            Object tempO = this.m_listenees.get(en.nextElement());
            if (!(tempO instanceof BeanCommon)) continue;
            ((BeanCommon)tempO).stop();
        }
        if (this.m_buildThread != null) {
            this.m_buildThread.interrupt();
            this.m_buildThread.stop();
            this.m_buildThread = null;
            this.m_visual.setStatic();
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public void saveModel() {
        block7: {
            try {
                int returnVal;
                if (this.m_fileChooser == null) {
                    this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
                    ExtensionFileFilter ef = new ExtensionFileFilter("model", "Serialized weka clusterer");
                    this.m_fileChooser.setFileFilter(ef);
                }
                if ((returnVal = this.m_fileChooser.showSaveDialog(this)) == 0) {
                    File saveTo = this.m_fileChooser.getSelectedFile();
                    String fn = saveTo.getAbsolutePath();
                    if (!fn.endsWith(".model")) {
                        fn = fn + ".model";
                        saveTo = new File(fn);
                    }
                    ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(saveTo)));
                    os.writeObject(this.m_Clusterer);
                    if (this.m_trainingSet != null) {
                        Instances header = new Instances(this.m_trainingSet, 0);
                        os.writeObject(header);
                    }
                    os.close();
                    if (this.m_log != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        this.m_log.logMessage(stringBuilder.append(Messages.getString("Clusterer_SaveModel_LogMessage_Text_Fourth")).append(this.getCustomName()).toString());
                    }
                }
            }
            catch (Exception ex) {
                Messages.getInstance();
                String string = Messages.getString("Clusterer_SaveModel_JOptionPane_ShowMessageDialog_Text_First");
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("Clusterer_SaveModel_JOptionPane_ShowMessageDialog_Text_Second"), 0);
                if (this.m_log == null) break block7;
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder.append(Messages.getString("Clusterer_SaveModel_LogMessage_Text_Fifth")).append(this.getCustomName()).append(ex.getMessage()).toString());
            }
        }
    }

    public void loadModel() {
        block6: {
            try {
                int returnVal;
                if (this.m_fileChooser == null) {
                    this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
                    ExtensionFileFilter ef = new ExtensionFileFilter("model", "Serialized weka clusterer");
                    this.m_fileChooser.setFileFilter(ef);
                }
                if ((returnVal = this.m_fileChooser.showOpenDialog(this)) != 0) break block6;
                File loadFrom = this.m_fileChooser.getSelectedFile();
                ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(loadFrom)));
                weka.clusterers.Clusterer temp = (weka.clusterers.Clusterer)is.readObject();
                this.setClusterer(temp);
                try {
                    this.m_trainingSet = (Instances)is.readObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                is.close();
                if (this.m_log != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    this.m_log.logMessage(stringBuilder.append(Messages.getString("Clusterer_LoadModel_LogMessage_Text_First")).append(this.m_Clusterer.getClass().toString()).toString());
                }
            }
            catch (Exception ex) {
                Messages.getInstance();
                String string = Messages.getString("Clusterer_LoadModel_JOptionPane_ShowMessageDialog_Text_First");
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("Clusterer_LoadModel_JOptionPane_ShowMessageDialog_Text_Second"), 0);
                if (this.m_log == null) break block6;
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder.append(Messages.getString("Clusterer_LoadModel_LogMessage_Text_Second")).append(ex.getMessage()).toString());
            }
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_buildThread != null) {
            newVector.addElement("Stop");
        }
        if (this.m_buildThread == null && this.m_Clusterer != null) {
            newVector.addElement("Save model");
        }
        if (this.m_buildThread == null) {
            newVector.addElement("Load model");
        }
        return newVector.elements();
    }

    public void performRequest(String request) {
        if (request.compareTo("Stop") == 0) {
            this.stop();
        } else if (request.compareTo("Save model") == 0) {
            this.saveModel();
        } else if (request.compareTo("Load model") == 0) {
            this.loadModel();
        } else {
            throw new IllegalArgumentException(request + " not supported (Clusterer)");
        }
    }

    public boolean eventGeneratable(EventSetDescriptor esd) {
        String eventName = esd.getName();
        return this.eventGeneratable(eventName);
    }

    public boolean eventGeneratable(String eventName) {
        Object source;
        if (eventName.compareTo("graph") == 0) {
            if (!(this.m_Clusterer instanceof Drawable)) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (eventName.compareTo("batchClusterer") == 0) {
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (eventName.compareTo("text") == 0) {
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (eventName.compareTo("batchClassifier") == 0) {
            return false;
        }
        return eventName.compareTo("incrementalClassifier") != 0;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Clusterer instanceof OptionHandler && Utils.joinOptions(((OptionHandler)((Object)this.m_Clusterer)).getOptions()).length() > 0 ? Utils.joinOptions(((OptionHandler)((Object)this.m_Clusterer)).getOptions()) + "|" : "");
    }
}

