/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.RandomizableClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class sIB
extends RandomizableClusterer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -8652125897352654213L;
    private Instances m_data;
    private int m_numCluster = 2;
    private int m_numRestarts = 5;
    private boolean m_verbose = false;
    private boolean m_uniformPrior = true;
    private int m_maxLoop = 100;
    private int m_minChange = 0;
    private ReplaceMissingValues m_replaceMissing;
    private int m_numInstances;
    private int m_numAttributes;
    private Random random;
    private Partition bestT;
    private Input input;

    public void buildClusterer(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_replaceMissing = new ReplaceMissingValues();
        Instances instances = new Instances(data);
        instances.setClassIndex(-1);
        this.m_replaceMissing.setInputFormat(instances);
        data = Filter.useFilter(instances, this.m_replaceMissing);
        instances = null;
        this.m_data = data;
        this.m_numInstances = this.m_data.numInstances();
        this.m_numAttributes = this.m_data.numAttributes();
        this.random = new Random(this.getSeed());
        this.input = this.sIB_ProcessInput();
        this.bestT = new Partition();
        double bestL = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < this.m_numRestarts; ++k) {
            if (this.m_verbose) {
                System.out.format("restart number %s...\n", k);
            }
            Partition tmpT = this.sIB_InitT(this.input);
            if ((tmpT = this.sIB_OptimizeT(tmpT, this.input)).L > bestL) {
                tmpT.copy(this.bestT);
                bestL = this.bestT.L;
            }
            if (!this.m_verbose) continue;
            System.out.println("\nPartition status : ");
            System.out.println("------------------");
            System.out.println(tmpT.toString() + "\n");
        }
        if (this.m_verbose) {
            System.out.println("\nBest Partition");
            System.out.println("===============");
            System.out.println(this.bestT.toString());
        }
        this.m_data = new Instances(this.m_data, 0);
    }

    public int clusterInstance(Instance instance) throws Exception {
        double prior = 1.0 / this.input.sumVals;
        double[] distances = new double[this.m_numCluster];
        for (int i = 0; i < this.m_numCluster; ++i) {
            double Pnew = this.bestT.Pt[i] + prior;
            double pi1 = prior / Pnew;
            double pi2 = this.bestT.Pt[i] / Pnew;
            distances[i] = Pnew * this.JS(instance, i, pi1, pi2);
        }
        return Utils.minIndex(distances);
    }

    private Input sIB_ProcessInput() {
        int j;
        int i;
        double valSum = 0.0;
        for (int i2 = 0; i2 < this.m_numInstances; ++i2) {
            valSum = 0.0;
            for (int v = 0; v < this.m_data.instance(i2).numValues(); ++v) {
                valSum += this.m_data.instance(i2).valueSparse(v);
            }
            if (!(valSum <= 0.0)) continue;
            if (this.m_verbose) {
                System.out.format("Instance %s sum of value = %s <= 0, removed.\n", i2, valSum);
            }
            this.m_data.delete(i2);
            --this.m_numInstances;
        }
        Input input = new Input();
        input.Py_x = this.getTransposedNormedMatrix(this.m_data);
        if (this.m_uniformPrior) {
            input.Pyx = input.Py_x.copy();
            this.normalizePrior(this.m_data);
        } else {
            input.Pyx = this.getTransposedMatrix(this.m_data);
        }
        input.sumVals = this.getTotalSum(this.m_data);
        input.Pyx.timesEquals(1.0 / input.sumVals);
        Input.access$1002(input, new double[this.m_numInstances]);
        for (i = 0; i < this.m_numInstances; ++i) {
            for (j = 0; j < this.m_numAttributes; ++j) {
                double[] dArray = input.Px;
                int n = i;
                dArray[n] = dArray[n] + input.Pyx.get(j, i);
            }
        }
        Input.access$1102(input, new double[this.m_numAttributes]);
        for (i = 0; i < input.Pyx.getRowDimension(); ++i) {
            for (j = 0; j < input.Pyx.getColumnDimension(); ++j) {
                double[] dArray = input.Py;
                int n = i;
                dArray[n] = dArray[n] + input.Pyx.get(i, j);
            }
        }
        this.MI(input.Pyx, input);
        return input;
    }

    private Partition sIB_InitT(Input input) {
        int i;
        Partition T = new Partition();
        int avgSize = (int)Math.ceil((double)this.m_numInstances / (double)this.m_numCluster);
        ArrayList permInstsIdx = new ArrayList();
        ArrayList<Integer> unassigned = new ArrayList<Integer>();
        for (i = 0; i < this.m_numInstances; ++i) {
            unassigned.add(i);
        }
        while (unassigned.size() != 0) {
            int t = this.random.nextInt(unassigned.size());
            permInstsIdx.add(unassigned.get(t));
            unassigned.remove(t);
        }
        for (i = 0; i < this.m_numCluster; ++i) {
            int j;
            int r2 = avgSize > permInstsIdx.size() ? permInstsIdx.size() : avgSize;
            for (j = 0; j < r2; ++j) {
                ((Partition)T).Pt_x[((Integer)permInstsIdx.get((int)j)).intValue()] = i;
            }
            for (j = 0; j < r2; ++j) {
                permInstsIdx.remove(0);
            }
        }
        for (i = 0; i < this.m_numCluster; ++i) {
            ArrayList indices = T.find(i);
            for (int j = 0; j < indices.size(); ++j) {
                double[] dArray = T.Pt;
                int n = i;
                dArray[n] = dArray[n] + input.Px[(Integer)indices.get(j)];
            }
            double[][] mArray = input.Pyx.getArray();
            for (int j = 0; j < this.m_numAttributes; ++j) {
                double sum = 0.0;
                for (int k = 0; k < indices.size(); ++k) {
                    sum += mArray[j][(Integer)indices.get(k)];
                }
                T.Py_t.set(j, i, sum /= T.Pt[i]);
            }
        }
        if (this.m_verbose) {
            System.out.println("Initializing...");
        }
        return T;
    }

    private Partition sIB_OptimizeT(Partition tmpT, Input input) {
        boolean done = false;
        int change = 0;
        int loopCounter = 0;
        if (this.m_verbose) {
            System.out.println("Optimizing...");
            System.out.println("-------------");
        }
        while (!done) {
            change = 0;
            for (int i = 0; i < this.m_numInstances; ++i) {
                int old_t = tmpT.Pt_x[i];
                if (tmpT.size(old_t) == 1) {
                    if (!this.m_verbose) continue;
                    System.out.format("cluster %s has only 1 doc remain\n", old_t);
                    continue;
                }
                this.reduce_x(i, old_t, tmpT, input);
                int new_t = this.clusterInstance(i, input, tmpT);
                if (new_t == old_t) continue;
                ++change;
                this.updateAssignment(i, new_t, tmpT, input.Px[i], input.Py_x);
            }
            Partition partition = tmpT;
            partition.counter = partition.counter + change;
            if (this.m_verbose) {
                System.out.format("iteration %s , changes : %s\n", loopCounter, change);
            }
            done = this.checkConvergence(change, loopCounter);
            ++loopCounter;
        }
        tmpT.L = this.sIB_local_MI(tmpT.Py_t, tmpT.Pt);
        if (this.m_verbose) {
            System.out.format("score (L) : %s \n", Utils.doubleToString(tmpT.L, 4));
        }
        return tmpT;
    }

    private void reduce_x(int instIdx, int t, Partition T, Input input) {
        ArrayList indices = T.find(t);
        double sum = 0.0;
        for (int i = 0; i < indices.size(); ++i) {
            if ((Integer)indices.get(i) == instIdx) continue;
            sum += input.Px[(Integer)indices.get(i)];
        }
        ((Partition)T).Pt[t] = sum;
        if (T.Pt[t] < 0.0) {
            System.out.format("Warning: probability < 0 (%s)\n", T.Pt[t]);
            ((Partition)T).Pt[t] = 0.0;
        }
        double[][] mArray = input.Pyx.getArray();
        for (int i = 0; i < this.m_numAttributes; ++i) {
            sum = 0.0;
            for (int j = 0; j < indices.size(); ++j) {
                if ((Integer)indices.get(j) == instIdx) continue;
                sum += mArray[i][(Integer)indices.get(j)];
            }
            T.Py_t.set(i, t, sum / T.Pt[t]);
        }
    }

    private void updateAssignment(int instIdx, int newt, Partition T, double Px, Matrix Py_x) {
        ((Partition)T).Pt_x[instIdx] = newt;
        double mass = Px + T.Pt[newt];
        double pi1 = Px / mass;
        double pi2 = T.Pt[newt] / mass;
        for (int i = 0; i < this.m_numAttributes; ++i) {
            T.Py_t.set(i, newt, pi1 * Py_x.get(i, instIdx) + pi2 * T.Py_t.get(i, newt));
        }
        ((Partition)T).Pt[newt] = mass;
    }

    private boolean checkConvergence(int change, int loops) {
        if (change <= this.m_minChange || loops >= this.m_maxLoop) {
            if (this.m_verbose) {
                System.out.format("\nsIB converged after %s iterations with %s changes\n", loops, change);
            }
            return true;
        }
        return false;
    }

    private int clusterInstance(int instIdx, Input input, Partition T) {
        double[] distances = new double[this.m_numCluster];
        for (int i = 0; i < this.m_numCluster; ++i) {
            double Pnew = input.Px[instIdx] + T.Pt[i];
            double pi1 = input.Px[instIdx] / Pnew;
            double pi2 = T.Pt[i] / Pnew;
            distances[i] = Pnew * this.JS(instIdx, input, T, i, pi1, pi2);
        }
        return Utils.minIndex(distances);
    }

    private double JS(int instIdx, Input input, Partition T, int t, double pi1, double pi2) {
        int i;
        if (Math.min(pi1, pi2) <= 0.0) {
            System.out.format("Warning: zero or negative weights in JS calculation! (pi1 %s, pi2 %s)\n", pi1, pi2);
            return 0.0;
        }
        Instance inst = this.m_data.instance(instIdx);
        double kl1 = 0.0;
        double kl2 = 0.0;
        double tmp = 0.0;
        for (i = 0; i < inst.numValues(); ++i) {
            tmp = input.Py_x.get(inst.index(i), instIdx);
            if (tmp == 0.0) continue;
            kl1 += tmp * Math.log(tmp / (tmp * pi1 + pi2 * T.Py_t.get(inst.index(i), t)));
        }
        for (i = 0; i < this.m_numAttributes; ++i) {
            tmp = T.Py_t.get(i, t);
            if (tmp == 0.0) continue;
            kl2 += tmp * Math.log(tmp / (input.Py_x.get(i, instIdx) * pi1 + pi2 * tmp));
        }
        return pi1 * kl1 + pi2 * kl2;
    }

    private double JS(Instance inst, int t, double pi1, double pi2) {
        int i;
        if (Math.min(pi1, pi2) <= 0.0) {
            System.out.format("Warning: zero or negative weights in JS calculation! (pi1 %s, pi2 %s)\n", pi1, pi2);
            return 0.0;
        }
        double sum = Utils.sum(inst.toDoubleArray());
        double kl1 = 0.0;
        double kl2 = 0.0;
        double tmp = 0.0;
        for (i = 0; i < inst.numValues(); ++i) {
            tmp = inst.valueSparse(i) / sum;
            if (tmp == 0.0) continue;
            kl1 += tmp * Math.log(tmp / (tmp * pi1 + pi2 * this.bestT.Py_t.get(inst.index(i), t)));
        }
        for (i = 0; i < this.m_numAttributes; ++i) {
            tmp = this.bestT.Py_t.get(i, t);
            if (tmp == 0.0) continue;
            kl2 += tmp * Math.log(tmp / (inst.value(i) * pi1 / sum + pi2 * tmp));
        }
        return pi1 * kl1 + pi2 * kl2;
    }

    private double sIB_local_MI(Matrix m, double[] Pt) {
        int i;
        double Hy = 0.0;
        double Ht = 0.0;
        for (i = 0; i < Pt.length; ++i) {
            Ht += Pt[i] * Math.log(Pt[i]);
        }
        Ht = -Ht;
        for (i = 0; i < this.m_numAttributes; ++i) {
            double Py = 0.0;
            for (int j = 0; j < this.m_numCluster; ++j) {
                Py += m.get(i, j) * Pt[j];
            }
            if (Py == 0.0) continue;
            Hy += Py * Math.log(Py);
        }
        Hy = -Hy;
        double Hyt = 0.0;
        double tmp = 0.0;
        for (int i2 = 0; i2 < m.getRowDimension(); ++i2) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                tmp = m.get(i2, j);
                if (tmp == 0.0 || Pt[j] == 0.0) continue;
                Hyt += (tmp *= Pt[j]) * Math.log(tmp);
            }
        }
        return Hy + Ht + Hyt;
    }

    private double getTotalSum(Instances data) {
        double sum = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            for (int v = 0; v < data.instance(i).numValues(); ++v) {
                sum += data.instance(i).valueSparse(v);
            }
        }
        return sum;
    }

    private Matrix getTransposedMatrix(Instances data) {
        double[][] temp = new double[data.numAttributes()][data.numInstances()];
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            for (int v = 0; v < inst.numValues(); ++v) {
                temp[inst.index((int)v)][i] = inst.valueSparse(v);
            }
        }
        Matrix My_x = new Matrix(temp);
        return My_x;
    }

    private void normalizePrior(Instances data) {
        for (int i = 0; i < data.numInstances(); ++i) {
            this.normalizeInstance(data.instance(i));
        }
    }

    private Instance normalizeInstance(Instance inst) {
        double[] vals = inst.toDoubleArray();
        double sum = Utils.sum(vals);
        int i = 0;
        while (i < vals.length) {
            int n = i++;
            vals[n] = vals[n] / sum;
        }
        return new Instance(inst.weight(), vals);
    }

    private Matrix getTransposedNormedMatrix(Instances data) {
        Matrix matrix = new Matrix(data.numAttributes(), data.numInstances());
        for (int i = 0; i < data.numInstances(); ++i) {
            double[] vals = data.instance(i).toDoubleArray();
            double sum = Utils.sum(vals);
            for (int v = 0; v < vals.length; ++v) {
                int n = v;
                vals[n] = vals[n] / sum;
                matrix.set(v, i, vals[v]);
            }
        }
        return matrix;
    }

    private void MI(Matrix m, Input input) {
        int minDimSize;
        int n = minDimSize = m.getColumnDimension() < m.getRowDimension() ? m.getColumnDimension() : m.getRowDimension();
        if (minDimSize < 2) {
            System.err.println("Warning : This is not a JOINT distribution");
            input.Hx = this.Entropy(m);
            input.Hy = 0.0;
            input.Ixy = 0.0;
            return;
        }
        input.Hx = this.Entropy(input.Px);
        input.Hy = this.Entropy(input.Py);
        double entropy = input.Hx + input.Hy;
        for (int i = 0; i < this.m_numInstances; ++i) {
            Instance inst = this.m_data.instance(i);
            for (int v = 0; v < inst.numValues(); ++v) {
                double tmp = m.get(inst.index(v), i);
                if (tmp <= 0.0) continue;
                entropy += tmp * Math.log(tmp);
            }
        }
        input.Ixy = entropy;
        if (this.m_verbose) {
            System.out.println("Ixy = " + input.Ixy);
        }
    }

    private double Entropy(double[] probs) {
        for (int i = 0; i < probs.length; ++i) {
            if (!(probs[i] <= 0.0)) continue;
            if (this.m_verbose) {
                System.out.println("Warning: Negative probability.");
            }
            return Double.NaN;
        }
        if (Math.abs(Utils.sum(probs) - 1.0) >= 1.0E-6) {
            if (this.m_verbose) {
                System.out.println("Warning: Not normalized.");
            }
            return Double.NaN;
        }
        double mi = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            mi += probs[i] * Math.log(probs[i]);
        }
        mi = -mi;
        return mi;
    }

    private double Entropy(Matrix p) {
        double mi = 0.0;
        for (int i = 0; i < p.getRowDimension(); ++i) {
            for (int j = 0; j < p.getColumnDimension(); ++j) {
                if (p.get(i, j) == 0.0) continue;
                mi += p.get(i, j) + Math.log(p.get(i, j));
            }
        }
        mi = -mi;
        return mi;
    }

    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('I', options);
        if (optionString.length() != 0) {
            this.setMaxIterations(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('M', options)).length() != 0) {
            this.setMinChange(new Integer(optionString));
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumClusters(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('R', options)).length() != 0) {
            this.setNumRestarts(new Integer(optionString));
        }
        this.setNotUnifyNorm(Utils.getFlag('U', options));
        this.setDebug(Utils.getFlag('V', options));
        super.setOptions(options);
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tmaximum number of iterations\n\t(default 100).", "I", 1, "-I <num>"));
        result.addElement(new Option("\tminimum number of changes in a single iteration\n\t(default 0).", "M", 1, "-M <num>"));
        result.addElement(new Option("\tnumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        result.addElement(new Option("\tnumber of restarts.\n\t(default 5).", "R", 1, "-R <num>"));
        result.addElement(new Option("\tset not to normalize the data\n\t(default true).", "U", 0, "-U"));
        result.addElement(new Option("\tset to output debug info\n\t(default false).", "V", 0, "-V"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-I");
        result.add("" + this.getMaxIterations());
        result.add("-M");
        result.add("" + this.getMinChange());
        result.add("-N");
        result.add("" + this.getNumClusters());
        result.add("-R");
        result.add("" + this.getNumRestarts());
        if (this.getNotUnifyNorm()) {
            result.add("-U");
        }
        if (this.getDebug()) {
            result.add("-V");
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String debugTipText() {
        return "If set to true, clusterer may output additional info to the console.";
    }

    public void setDebug(boolean v) {
        this.m_verbose = v;
    }

    public boolean getDebug() {
        return this.m_verbose;
    }

    public String maxIterationsTipText() {
        return "set maximum number of iterations (default 100)";
    }

    public void setMaxIterations(int i) {
        this.m_maxLoop = i;
    }

    public int getMaxIterations() {
        return this.m_maxLoop;
    }

    public String minChangeTipText() {
        return "set minimum number of changes (default 0)";
    }

    public void setMinChange(int m) {
        this.m_minChange = m;
    }

    public int getMinChange() {
        return this.m_minChange;
    }

    public String numClustersTipText() {
        return "set number of clusters (default 2)";
    }

    public void setNumClusters(int n) {
        this.m_numCluster = n;
    }

    public int getNumClusters() {
        return this.m_numCluster;
    }

    public int numberOfClusters() {
        return this.m_numCluster;
    }

    public String numRestartsTipText() {
        return "set number of restarts (default 5)";
    }

    public void setNumRestarts(int i) {
        this.m_numRestarts = i;
    }

    public int getNumRestarts() {
        return this.m_numRestarts;
    }

    public String notUnifyNormTipText() {
        return "set whether to normalize each instance to a unify prior probability (eg. 1).";
    }

    public void setNotUnifyNorm(boolean b) {
        this.m_uniformPrior = !b;
    }

    public boolean getNotUnifyNorm() {
        return !this.m_uniformPrior;
    }

    public String globalInfo() {
        return "Cluster data using the sequential information bottleneck algorithm.\n\nNote: only hard clustering scheme is supported. sIB assign for each instance the cluster that have the minimum cost/distance to the instance. The trade-off beta is set to infinite so 1/beta is zero.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Noam Slonim and Nir Friedman and Naftali Tishby");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "Unsupervised document classification using sequential information maximization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 25th International ACM SIGIR Conference on Research and Development in Information Retrieval");
        result.setValue(TechnicalInformation.Field.PAGES, "129-136");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("\nsIB\n===\n");
        text.append("\nNumber of clusters: " + this.m_numCluster + "\n");
        for (int j = 0; j < this.m_numCluster; ++j) {
            text.append("\nCluster: " + j + " Size : " + this.bestT.size(j) + " Prior probability: " + Utils.doubleToString(this.bestT.Pt[j], 4) + "\n\n");
            for (int i = 0; i < this.m_numAttributes; ++i) {
                text.append("Attribute: " + this.m_data.attribute(i).name() + "\n");
                text.append("Probability given the cluster = " + Utils.doubleToString(this.bestT.Py_t.get(i, j), 4) + "\n");
            }
        }
        return text.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] argv) {
        sIB.runClusterer(new sIB(), argv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Partition
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 4957194978951259946L;
        private int[] Pt_x;
        private double[] Pt;
        private double L;
        private int counter;
        private Matrix Py_t;

        public Partition() {
            this.Pt_x = new int[sIB.this.m_numInstances];
            for (int i = 0; i < sIB.this.m_numInstances; ++i) {
                this.Pt_x[i] = -1;
            }
            this.Pt = new double[sIB.this.m_numCluster];
            this.Py_t = new Matrix(sIB.this.m_numAttributes, sIB.this.m_numCluster);
            this.counter = 0;
        }

        private ArrayList<Integer> find(int i) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int x = 0; x < this.Pt_x.length; ++x) {
                if (this.Pt_x[x] != i) continue;
                indices.add(x);
            }
            return indices;
        }

        private int size(int i) {
            int count = 0;
            for (int x = 0; x < this.Pt_x.length; ++x) {
                if (this.Pt_x[x] != i) continue;
                ++count;
            }
            return count;
        }

        private void copy(Partition T) {
            if (T == null) {
                T = new Partition();
            }
            System.arraycopy(this.Pt_x, 0, T.Pt_x, 0, this.Pt_x.length);
            System.arraycopy(this.Pt, 0, T.Pt, 0, this.Pt.length);
            T.L = this.L;
            T.counter = this.counter;
            double[][] mArray = this.Py_t.getArray();
            double[][] tgtArray = T.Py_t.getArray();
            for (int i = 0; i < mArray.length; ++i) {
                System.arraycopy(mArray[i], 0, tgtArray[i], 0, mArray[0].length);
            }
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            text.append("score (L) : " + Utils.doubleToString(this.L, 4) + "\n");
            text.append("number of changes : " + this.counter + "\n");
            for (int i = 0; i < sIB.this.m_numCluster; ++i) {
                text.append("\nCluster " + i + "\n");
                text.append("size : " + this.size(i) + "\n");
                text.append("prior prob : " + Utils.doubleToString(this.Pt[i], 4) + "\n");
            }
            return text.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5538 $");
        }
    }

    private class Input
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -2464453171263384037L;
        private double[] Px;
        private double[] Py;
        private Matrix Pyx;
        private Matrix Py_x;
        private double Ixy;
        private double Hy;
        private double Hx;
        private double sumVals;

        private Input() {
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5538 $");
        }

        static /* synthetic */ double[] access$1002(Input x0, double[] x1) {
            x0.Px = x1;
            return x1;
        }

        static /* synthetic */ double[] access$1102(Input x0, double[] x1) {
            x0.Py = x1;
            return x1;
        }
    }
}

