/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
 
package napping.core;

import java.io.Serializable;
import java.util.List;
import java.util.Random;

/**
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public abstract class Policy implements Serializable {

    protected int numIteration;
    protected Random random;

    public abstract Action makeDecisionS(State s, Task t, Random random);

    public abstract Action makeDecisionD(State s, Task t, Random random);

    public abstract long[] train(Task task, int iteration, int trialsPerIter, 
            State initialState, int maxStep, boolean isPara, Random random);

    protected abstract void update(List<Trajectory> rollouts, int maxStep);

    public int getNumIteration() {
        return numIteration;
    }

    public abstract void setNumIteration(int numIteration);

    public Random getRandom() {
        return random;
    }
}
