/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
 
package napping.policy;

import napping.core.Action;
import napping.core.Policy;
import napping.core.Trajectory;
import napping.core.State;
import napping.core.Task;
import java.util.List;
import java.util.Random;

/**
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public class RandomPolicy extends Policy {

    Random random;

    public RandomPolicy(Random rand) {
        random = rand;
    }

    @Override
    public Action makeDecisionS(State s, Task t, Random outRand) {
        Random thisRand = outRand == null ? random : outRand;
        int A = t.actionSet.length;

        double[] utilities = new double[A];
        for (int a = 0; a < A; a++) {
            utilities[a] = 1.0 / A;
        }

        int bestAction = -1;
        double p = thisRand.nextDouble(), totalShare = 0;
        for (int a = 0; a < A; a++) {
            totalShare += utilities[a];
            if (p <= totalShare) {
                bestAction = a;
                break;
            }
        }

        return new Action(bestAction, utilities[bestAction]);
    }

    @Override
    public Action makeDecisionD(State s, Task t, Random outRand) {
        return makeDecisionS(s, t, outRand);
    }

    @Override
    public void update(List<Trajectory> rollouts, int maxStep) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNumIteration(int numIteration) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] train(Task task, int iteration, int trialsPerIter,
            State initialState, int maxStep, boolean isPara, Random random) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
