/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */

package demo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import napping.core.Task;
import napping.domain.corridorworld.CWTask;
import napping.policy.NPPGWithNappingA;
import napping.policy.NPPGWithNappingV;

/**
 * This file runs NPPG with napping as in the following paper for the Corridor domain
 *
 * Qing Da, Yang Yu, and Zhi-Hua Zhou. Napping for functional representation 
 * of policy. In: Proceedings of the 2014 International Conference on Autonomous
 * Agents and Multi-Agent Systems (AAMAS'14), Paris, France, 2014.
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public class CWDemo {

    static int maxIter = 2000;
    static boolean isPara = true;

    public static void main(String[] args) throws Exception {
        testNPPG();
        testNPPGWithNappingV(10, 5000);
        testNPPGWithNappingA(10, 5000, 0.05);
    }

    private static void testNPPG() throws IOException {
        Random random = new Random();
        random.nextInt();
        random.nextInt();

        CWTask task = new CWTask(new Random());

        List<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < 500; i++) {
            tasks.add(task);
        }

        // by setting napInterval to Integer.MAX_VALUE, we obtain the original NPPG
        NPPGWithNappingV napPolicy = new NPPGWithNappingV(Integer.MAX_VALUE, Integer.MIN_VALUE, new Random(random.nextInt()));
        napPolicy.setStationaryRate(0.5);
        napPolicy.setStepsize(0.05);
        napPolicy.setEpsionGreedy(0.1);
        napPolicy.setEpsionGreedyDecay(1);
        napPolicy.trainAndTest(tasks, task, 100, 10, null, maxIter, true, random);

    }

    private static void testNPPGWithNappingV(int napInterval, int exampleSzie) throws IOException {
        Random random = new Random();
        random.nextInt();
        random.nextInt();

        CWTask task = new CWTask(new Random());

        List<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < 500; i++) {
            tasks.add(task);
        }
        NPPGWithNappingV napPolicy = new NPPGWithNappingV(napInterval, exampleSzie, new Random(random.nextInt()));
        napPolicy.setStationaryRate(0.5);
        napPolicy.setStepsize(0.05);
        napPolicy.setEpsionGreedy(0.1);
        napPolicy.setEpsionGreedyDecay(1);
        napPolicy.trainAndTest(tasks, task, 100, 10, null, maxIter, true, random);
    }

    private static void testNPPGWithNappingA(int napInterval, int exampleSzie, double napWeight) throws IOException {
        Random random = new Random();
        random.nextInt();
        random.nextInt();

        CWTask task = new CWTask(new Random());

        List<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < 500; i++) {
            tasks.add(task);
        }
        NPPGWithNappingA napPolicy = new NPPGWithNappingA(napInterval, exampleSzie, new Random(random.nextInt()));
        napPolicy.setNapWeight(napWeight);
        napPolicy.setStationaryRate(0.5);
        napPolicy.setStepsize(0.05);
        napPolicy.setEpsionGreedy(0.1);
        napPolicy.setEpsionGreedyDecay(1);
        napPolicy.trainAndTest(tasks, task, 100, 10, null, maxIter, true, random);
    }
}
