/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Copyright (C) 2014 Nanjing University, Nanjing, China
 */
 
package napping.domain.acrobot;

import napping.core.State;

/**
 *
 * @author Qing Da <daq@lamda.nju.edu.cn>
 */
public class AcrobotState extends State {

    public double theta1, theta2, theta1Dot, theta2Dot;

    public AcrobotState(double theta1, double theta2, double theta1Dot, double theta2Dot) {
        this.theta1 = theta1;
        this.theta2 = theta2;
        this.theta1Dot = theta1Dot;
        this.theta2Dot = theta2Dot;
    }

    @Override
    public double[] extractFeature() {
        double[] fea = new double[4];
        int m = 0;
        fea[m++] = theta1;
        fea[m++] = theta2;
        fea[m++] = theta1Dot;
        fea[m++] = theta2Dot;
        return fea;
    }
}
