/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class PrincipalComponents
extends UnsupervisedAttributeEvaluator
implements AttributeTransformer,
OptionHandler {
    private static final long serialVersionUID = -3675307197777734007L;
    private Instances m_trainInstances;
    private Instances m_trainHeader;
    private Instances m_transformedFormat;
    private Instances m_originalSpaceFormat;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private double[][] m_correlation;
    private double[] m_means;
    private double[] m_stdDevs;
    private boolean m_center = false;
    private double[][] m_eigenvectors;
    private double[] m_eigenvalues = null;
    private int[] m_sortedEigens;
    private double m_sumOfEigenValues = 0.0;
    private ReplaceMissingValues m_replaceMissingFilter;
    private NominalToBinary m_nominalToBinFilter;
    private Remove m_attributeFilter;
    private Center m_centerFilter;
    private Standardize m_standardizeFilter;
    private int m_outputNumAtts = -1;
    private double m_coverVariance = 0.95;
    private boolean m_transBackToOriginal = false;
    private int m_maxAttrsInName = 5;
    private double[][] m_eTranspose;

    public String globalInfo() {
        return "Performs a principal components analysis and transformation of the data. Use in conjunction with a Ranker search. Dimensionality reduction is accomplished by choosing enough eigenvectors to account for some percentage of the variance in the original data---default 0.95 (95%). Attribute noise can be filtered by transforming to the PC space, eliminating some of the worst eigenvectors, and then transforming back to the original space.";
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tCenter (rather than standardize) the\n\tdata and compute PCA using the covariance (rather\n\t than the correlation) matrix.", "C", 0, "-C"));
        newVector.addElement(new Option("\tRetain enough PC attributes to account \n\tfor this proportion of variance in the original data.\n\t(default = 0.95)", "R", 1, "-R"));
        newVector.addElement(new Option("\tTransform through the PC space and \n\tback to the original space.", "O", 0, "-O"));
        newVector.addElement(new Option("\tMaximum number of attributes to include in \n\ttransformed attribute names. (-1 = include all)", "A", 1, "-A"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('R', options);
        if (optionString.length() != 0) {
            Double temp = Double.valueOf(optionString);
            this.setVarianceCovered(temp);
        }
        if ((optionString = Utils.getOption('A', options)).length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(optionString));
        }
        this.setTransformBackToOriginal(Utils.getFlag('O', options));
        this.setCenterData(Utils.getFlag('C', options));
    }

    private void resetOptions() {
        this.m_coverVariance = 0.95;
        this.m_sumOfEigenValues = 0.0;
        this.m_transBackToOriginal = false;
    }

    public String centerDataTipText() {
        return "Center (rather than standardize) the data. PCA will be computed from the covariance (rather than correlation) matrix";
    }

    public void setCenterData(boolean center) {
        this.m_center = center;
    }

    public boolean getCenterData() {
        return this.m_center;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setVarianceCovered(double vc) {
        this.m_coverVariance = vc;
    }

    public double getVarianceCovered() {
        return this.m_coverVariance;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int m) {
        this.m_maxAttrsInName = m;
    }

    public int getMaximumAttributeNames() {
        return this.m_maxAttrsInName;
    }

    public String transformBackToOriginalTipText() {
        return "Transform through the PC space and back to the original space. If only the best n PCs are retained (by setting varianceCovered < 1) then this option will give a dataset in the original space but with less attribute noise.";
    }

    public void setTransformBackToOriginal(boolean b) {
        this.m_transBackToOriginal = b;
    }

    public boolean getTransformBackToOriginal() {
        return this.m_transBackToOriginal;
    }

    public String[] getOptions() {
        String[] options = new String[6];
        int current = 0;
        if (this.getCenterData()) {
            options[current++] = "-C";
        }
        options[current++] = "-R";
        options[current++] = "" + this.getVarianceCovered();
        options[current++] = "-A";
        options[current++] = "" + this.getMaximumAttributeNames();
        if (this.getTransformBackToOriginal()) {
            options[current++] = "-O";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.buildAttributeConstructor(data);
    }

    private void buildAttributeConstructor(Instances data) throws Exception {
        this.m_eigenvalues = null;
        this.m_outputNumAtts = -1;
        this.m_attributeFilter = null;
        this.m_nominalToBinFilter = null;
        this.m_sumOfEigenValues = 0.0;
        this.m_trainInstances = new Instances(data);
        this.m_trainHeader = new Instances(this.m_trainInstances, 0);
        this.m_replaceMissingFilter = new ReplaceMissingValues();
        this.m_replaceMissingFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_replaceMissingFilter);
        this.m_nominalToBinFilter = new NominalToBinary();
        this.m_nominalToBinFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_nominalToBinFilter);
        Vector<Integer> deleteCols = new Vector<Integer>();
        for (int i = 0; i < this.m_trainInstances.numAttributes(); ++i) {
            if (this.m_trainInstances.numDistinctValues(i) > 1) continue;
            deleteCols.addElement(new Integer(i));
        }
        if (this.m_trainInstances.classIndex() >= 0) {
            this.m_hasClass = true;
            this.m_classIndex = this.m_trainInstances.classIndex();
            deleteCols.addElement(new Integer(this.m_classIndex));
        }
        if (deleteCols.size() > 0) {
            this.m_attributeFilter = new Remove();
            int[] todelete = new int[deleteCols.size()];
            for (int i = 0; i < deleteCols.size(); ++i) {
                todelete[i] = (Integer)deleteCols.elementAt(i);
            }
            this.m_attributeFilter.setAttributeIndicesArray(todelete);
            this.m_attributeFilter.setInvertSelection(false);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_attributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_trainInstances);
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.fillCovariance();
        double[] d = new double[this.m_numAttribs];
        double[][] v = new double[this.m_numAttribs][this.m_numAttribs];
        Matrix corr = new Matrix(this.m_correlation);
        corr.eigenvalueDecomposition(v, d);
        this.m_eigenvectors = (double[][])v.clone();
        this.m_eigenvalues = (double[])d.clone();
        for (int i = 0; i < this.m_eigenvalues.length; ++i) {
            if (!(this.m_eigenvalues[i] < 0.0)) continue;
            this.m_eigenvalues[i] = 0.0;
        }
        this.m_sortedEigens = Utils.sort(this.m_eigenvalues);
        this.m_sumOfEigenValues = Utils.sum(this.m_eigenvalues);
        this.m_transformedFormat = this.setOutputFormat();
        if (this.m_transBackToOriginal) {
            this.m_originalSpaceFormat = this.setOutputFormatOriginal();
            int numVectors = this.m_transformedFormat.classIndex() < 0 ? this.m_transformedFormat.numAttributes() : this.m_transformedFormat.numAttributes() - 1;
            double[][] orderedVectors = new double[this.m_eigenvectors.length][numVectors + 1];
            for (int i = this.m_numAttribs - 1; i > this.m_numAttribs - numVectors - 1; --i) {
                for (int j = 0; j < this.m_numAttribs; ++j) {
                    orderedVectors[j][this.m_numAttribs - i] = this.m_eigenvectors[j][this.m_sortedEigens[i]];
                }
            }
            int nr = orderedVectors.length;
            int nc = orderedVectors[0].length;
            this.m_eTranspose = new double[nc][nr];
            for (int i = 0; i < nc; ++i) {
                for (int j = 0; j < nr; ++j) {
                    this.m_eTranspose[i][j] = orderedVectors[j][i];
                }
            }
        }
    }

    public Instances transformedHeader() throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet");
        }
        if (this.m_transBackToOriginal) {
            return this.m_originalSpaceFormat;
        }
        return this.m_transformedFormat;
    }

    public Instances transformedData(Instances data) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet");
        }
        Instances output = null;
        output = this.m_transBackToOriginal ? new Instances(this.m_originalSpaceFormat) : new Instances(this.m_transformedFormat);
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance converted = this.convertInstance(data.instance(i));
            output.add(converted);
        }
        return output;
    }

    public double evaluateAttribute(int att) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("Principal components hasn't been built yet!");
        }
        if (this.m_transBackToOriginal) {
            return 1.0;
        }
        double cumulative = 0.0;
        for (int i = this.m_numAttribs - 1; i >= this.m_numAttribs - att - 1; --i) {
            cumulative += this.m_eigenvalues[this.m_sortedEigens[i]];
        }
        return 1.0 - cumulative / this.m_sumOfEigenValues;
    }

    private void fillCovariance() throws Exception {
        this.m_means = new double[this.m_trainInstances.numAttributes()];
        this.m_stdDevs = new double[this.m_trainInstances.numAttributes()];
        for (int i = 0; i < this.m_trainInstances.numAttributes(); ++i) {
            this.m_means[i] = this.m_trainInstances.meanOrMode(i);
        }
        if (!this.m_center) {
            this.fillCorrelation();
            return;
        }
        double[] att = new double[this.m_trainInstances.numInstances()];
        this.m_centerFilter = new Center();
        this.m_centerFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_centerFilter);
        this.m_correlation = new double[this.m_numAttribs][this.m_numAttribs];
        for (int i = 0; i < this.m_numAttribs; ++i) {
            for (int j = 0; j < this.m_numAttribs; ++j) {
                double cov = 0.0;
                for (int k = 0; k < this.m_numInstances; ++k) {
                    if (i == j) {
                        cov += this.m_trainInstances.instance(k).value(i) * this.m_trainInstances.instance(k).value(i);
                        continue;
                    }
                    cov += this.m_trainInstances.instance(k).value(i) * this.m_trainInstances.instance(k).value(j);
                }
                this.m_correlation[i][j] = cov /= (double)(this.m_trainInstances.numInstances() - 1);
                this.m_correlation[j][i] = cov;
            }
        }
    }

    private void fillCorrelation() throws Exception {
        this.m_correlation = new double[this.m_numAttribs][this.m_numAttribs];
        double[] att1 = new double[this.m_numInstances];
        double[] att2 = new double[this.m_numInstances];
        for (int i = 0; i < this.m_numAttribs; ++i) {
            for (int j = 0; j < this.m_numAttribs; ++j) {
                double corr;
                for (int k = 0; k < this.m_numInstances; ++k) {
                    att1[k] = this.m_trainInstances.instance(k).value(i);
                    att2[k] = this.m_trainInstances.instance(k).value(j);
                }
                if (i == j) {
                    this.m_correlation[i][j] = 1.0;
                    this.m_stdDevs[i] = Math.sqrt(Utils.variance(att1));
                    continue;
                }
                this.m_correlation[i][j] = corr = Utils.correlation(att1, att2, this.m_numInstances);
                this.m_correlation[j][i] = corr;
            }
        }
        this.m_standardizeFilter = new Standardize();
        this.m_standardizeFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_standardizeFilter);
    }

    private String principalComponentsSummary() {
        int j;
        StringBuffer result = new StringBuffer();
        double cumulative = 0.0;
        Instances output = null;
        int numVectors = 0;
        try {
            output = this.setOutputFormat();
            numVectors = output.classIndex() < 0 ? output.numAttributes() : output.numAttributes() - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String corrCov = this.m_center ? "Covariance " : "Correlation ";
        result.append(corrCov + "matrix\n" + this.matrixToString(this.m_correlation) + "\n\n");
        result.append("eigenvalue\tproportion\tcumulative\n");
        for (int i = this.m_numAttribs - 1; i > this.m_numAttribs - numVectors - 1; --i) {
            result.append(Utils.doubleToString(this.m_eigenvalues[this.m_sortedEigens[i]], 9, 5) + "\t" + Utils.doubleToString(this.m_eigenvalues[this.m_sortedEigens[i]] / this.m_sumOfEigenValues, 9, 5) + "\t" + Utils.doubleToString((cumulative += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues, 9, 5) + "\t" + output.attribute(this.m_numAttribs - i - 1).name() + "\n");
        }
        result.append("\nEigenvectors\n");
        for (j = 1; j <= numVectors; ++j) {
            result.append(" V" + j + '\t');
        }
        result.append("\n");
        for (j = 0; j < this.m_numAttribs; ++j) {
            for (int i = this.m_numAttribs - 1; i > this.m_numAttribs - numVectors - 1; --i) {
                result.append(Utils.doubleToString(this.m_eigenvectors[j][this.m_sortedEigens[i]], 7, 4) + "\t");
            }
            result.append(this.m_trainInstances.attribute(j).name() + '\n');
        }
        if (this.m_transBackToOriginal) {
            result.append("\nPC space transformed back to original space.\n(Note: can't evaluate attributes in the original space)\n");
        }
        return result.toString();
    }

    public String toString() {
        if (this.m_eigenvalues == null) {
            return "Principal components hasn't been built yet!";
        }
        return "\tPrincipal Components Attribute Transformer\n\n" + this.principalComponentsSummary();
    }

    private String matrixToString(double[][] matrix) {
        StringBuffer result = new StringBuffer();
        int last = matrix.length - 1;
        for (int i = 0; i <= last; ++i) {
            for (int j = 0; j <= last; ++j) {
                result.append(Utils.doubleToString(matrix[i][j], 6, 2) + " ");
                if (j != last) continue;
                result.append('\n');
            }
        }
        return result.toString();
    }

    private Instance convertInstanceToOriginal(Instance inst) throws Exception {
        double[] newVals = null;
        newVals = this.m_hasClass ? new double[this.m_numAttribs + 1] : new double[this.m_numAttribs];
        if (this.m_hasClass) {
            newVals[this.m_numAttribs] = inst.value(inst.numAttributes() - 1);
        }
        for (int i = 0; i < this.m_eTranspose[0].length; ++i) {
            double tempval = 0.0;
            for (int j = 1; j < this.m_eTranspose.length; ++j) {
                tempval += this.m_eTranspose[j][i] * inst.value(j - 1);
            }
            newVals[i] = tempval;
            if (!this.m_center) {
                int n = i;
                newVals[n] = newVals[n] * this.m_stdDevs[i];
            }
            int n = i;
            newVals[n] = newVals[n] + this.m_means[i];
        }
        if (inst instanceof SparseInstance) {
            return new SparseInstance(inst.weight(), newVals);
        }
        return new Instance(inst.weight(), newVals);
    }

    public Instance convertInstance(Instance instance) throws Exception {
        if (this.m_eigenvalues == null) {
            throw new Exception("convertInstance: Principal components not built yet");
        }
        double[] newVals = new double[this.m_outputNumAtts];
        Instance tempInst = (Instance)instance.copy();
        if (!instance.dataset().equalHeaders(this.m_trainHeader)) {
            throw new Exception("Can't convert instance: header's don't match: PrincipalComponents\nCan't convert instance: header's don't match.");
        }
        this.m_replaceMissingFilter.input(tempInst);
        this.m_replaceMissingFilter.batchFinished();
        tempInst = this.m_replaceMissingFilter.output();
        this.m_nominalToBinFilter.input(tempInst);
        this.m_nominalToBinFilter.batchFinished();
        tempInst = this.m_nominalToBinFilter.output();
        if (this.m_attributeFilter != null) {
            this.m_attributeFilter.input(tempInst);
            this.m_attributeFilter.batchFinished();
            tempInst = this.m_attributeFilter.output();
        }
        if (!this.m_center) {
            this.m_standardizeFilter.input(tempInst);
            this.m_standardizeFilter.batchFinished();
            tempInst = this.m_standardizeFilter.output();
        } else {
            this.m_centerFilter.input(tempInst);
            this.m_centerFilter.batchFinished();
            tempInst = this.m_centerFilter.output();
        }
        if (this.m_hasClass) {
            newVals[this.m_outputNumAtts - 1] = instance.value(instance.classIndex());
        }
        double cumulative = 0.0;
        for (int i = this.m_numAttribs - 1; i >= 0; --i) {
            double tempval = 0.0;
            for (int j = 0; j < this.m_numAttribs; ++j) {
                tempval += this.m_eigenvectors[j][this.m_sortedEigens[i]] * tempInst.value(j);
            }
            newVals[this.m_numAttribs - i - 1] = tempval;
            if ((cumulative += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues >= this.m_coverVariance) break;
        }
        if (!this.m_transBackToOriginal) {
            if (instance instanceof SparseInstance) {
                return new SparseInstance(instance.weight(), newVals);
            }
            return new Instance(instance.weight(), newVals);
        }
        if (instance instanceof SparseInstance) {
            return this.convertInstanceToOriginal(new SparseInstance(instance.weight(), newVals));
        }
        return this.convertInstanceToOriginal(new Instance(instance.weight(), newVals));
    }

    private Instances setOutputFormatOriginal() throws Exception {
        FastVector attributes = new FastVector();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            String att = this.m_trainInstances.attribute(i).name();
            attributes.addElement(new Attribute(att));
        }
        if (this.m_hasClass) {
            attributes.addElement(this.m_trainHeader.classAttribute().copy());
        }
        Instances outputFormat = new Instances(this.m_trainHeader.relationName() + "->PC->original space", attributes, 0);
        if (this.m_hasClass) {
            outputFormat.setClassIndex(outputFormat.numAttributes() - 1);
        }
        return outputFormat;
    }

    private Instances setOutputFormat() throws Exception {
        if (this.m_eigenvalues == null) {
            return null;
        }
        double cumulative = 0.0;
        FastVector attributes = new FastVector();
        for (int i = this.m_numAttribs - 1; i >= 0; --i) {
            int j;
            int[] coeff_inds;
            int num_attrs;
            StringBuffer attName = new StringBuffer();
            double[] coeff_mags = new double[this.m_numAttribs];
            for (int j2 = 0; j2 < this.m_numAttribs; ++j2) {
                coeff_mags[j2] = -Math.abs(this.m_eigenvectors[j2][this.m_sortedEigens[i]]);
            }
            int n = num_attrs = this.m_maxAttrsInName > 0 ? Math.min(this.m_numAttribs, this.m_maxAttrsInName) : this.m_numAttribs;
            if (this.m_numAttribs > 0) {
                coeff_inds = Utils.sort(coeff_mags);
            } else {
                coeff_inds = new int[this.m_numAttribs];
                for (j = 0; j < this.m_numAttribs; ++j) {
                    coeff_inds[j] = j;
                }
            }
            for (j = 0; j < num_attrs; ++j) {
                double coeff_value = this.m_eigenvectors[coeff_inds[j]][this.m_sortedEigens[i]];
                if (j > 0 && coeff_value >= 0.0) {
                    attName.append("+");
                }
                attName.append(Utils.doubleToString(coeff_value, 5, 3) + this.m_trainInstances.attribute(coeff_inds[j]).name());
            }
            if (num_attrs < this.m_numAttribs) {
                attName.append("...");
            }
            attributes.addElement(new Attribute(attName.toString()));
            if ((cumulative += this.m_eigenvalues[this.m_sortedEigens[i]]) / this.m_sumOfEigenValues >= this.m_coverVariance) break;
        }
        if (this.m_hasClass) {
            attributes.addElement(this.m_trainHeader.classAttribute().copy());
        }
        Instances outputFormat = new Instances(this.m_trainInstances.relationName() + "_principal components", attributes, 0);
        if (this.m_hasClass) {
            outputFormat.setClassIndex(outputFormat.numAttributes() - 1);
        }
        this.m_outputNumAtts = outputFormat.numAttributes();
        return outputFormat;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6690 $");
    }

    public static void main(String[] argv) {
        PrincipalComponents.runEvaluator(new PrincipalComponents(), argv);
    }
}

